/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.maachang.mimdb.Mimdb;
import org.maachang.mimdb.core.util.AtomicNumber;
import org.maachang.mimdb.jdbc.MimdbJdbcConnection;

public class Driver
implements java.sql.Driver {
    private static final String HEAD_URL = "jdbc:mimdb:";
    private static final int HEAD_URL_LENGTH = "jdbc:mimdb:".length();
    private static final Driver INSTANCE = new Driver();
    private static final AtomicNumber regFlag = new AtomicNumber(0L);

    static {
        try {
            Driver.load();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Driver() {
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String base = url;
        if (!this.acceptsURL(url)) {
            throw new SQLException("URL\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059:" + url);
        }
        url = url.substring(HEAD_URL_LENGTH).trim();
        try {
            Mimdb.getInstance().getDatabase(url);
            return new MimdbJdbcConnection();
        }
        catch (Exception e) {
            throw new SQLException("URL\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557:" + base, e);
        }
    }

    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith(HEAD_URL);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static final void load() throws SQLException {
        long old = regFlag.setToBeforeReturn(1L);
        if (old == 0L) {
            try {
                DriverManager.registerDriver(INSTANCE);
            }
            catch (SQLException e) {
                regFlag.set(old);
                throw e;
            }
        }
    }

    public static final void unload() throws SQLException {
        long old = regFlag.setToBeforeReturn(0L);
        if (old == 1L) {
            try {
                DriverManager.deregisterDriver(INSTANCE);
                regFlag.set(0L);
            }
            catch (SQLException e) {
                regFlag.set(old);
                throw e;
            }
        }
    }

    public static final boolean isRegister() {
        return regFlag.get() == 1L;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

