/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.crypto;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

class CryptoUtils_DecodeJSON {
    private static final int TYPE_ARRAY = 0;
    private static final int TYPE_MAP = 1;
    private static final String NEW_DATE = "Date";
    private static final int NEW_DATE_LEN = "Date".length();

    private CryptoUtils_DecodeJSON() {
    }

    public static final Object execution(String json) throws Exception {
        if (json == null) {
            return null;
        }
        int[] n = new int[1];
        json = json.trim();
        if ((json = CryptoUtils_DecodeJSON.cutComment(json).trim()).length() == 0) {
            return json;
        }
        while (true) {
            if (json.startsWith("[") || json.startsWith("{")) {
                List<Object> list = CryptoUtils_DecodeJSON.analysisJsonToken(json);
                if ("[".equals(list.get(0))) {
                    return CryptoUtils_DecodeJSON.createJsonInfo(n, list, 0, 0, list.size());
                }
                return CryptoUtils_DecodeJSON.createJsonInfo(n, list, 1, 0, list.size());
            }
            if (!json.startsWith("(") || !json.endsWith(")")) break;
            json = json.substring(1, json.length() - 1).trim();
        }
        return CryptoUtils_DecodeJSON.decJsonValue(n, 0, json);
    }

    private static final Object decJsonValue(int[] n, int no, String json) throws Exception {
        int x;
        int len = json.length();
        if (len <= 0) {
            return json;
        }
        if (json.startsWith("\"") && json.endsWith("\"") || json.startsWith("'") && json.endsWith("'")) {
            return json.substring(1, len - 1);
        }
        if ("null".equals(json)) {
            return null;
        }
        if ("true".equals(json)) {
            return Boolean.TRUE;
        }
        if ("false".equals(json)) {
            return Boolean.FALSE;
        }
        if (CryptoUtils_DecodeJSON.isNumber(n, json)) {
            if (n[0] == 4) {
                return Double.parseDouble(json);
            }
            return Long.parseLong(json);
        }
        if (json.startsWith("new") && (x = CryptoUtils_DecodeJSON.indexByEquals(json, NEW_DATE, 0)) != -1) {
            int b = x + NEW_DATE_LEN;
            x = CryptoUtils_DecodeJSON.indexParAndCote(json, '(', ')', b);
            b = CryptoUtils_DecodeJSON.indexByEquals(json, "(", b);
            if (x == -1) {
                throw new IOException("JSON\u89e3\u6790\u306b\u5931\u6557(" + json + "):No:" + no);
            }
            String s = json.substring(b + 1, x).trim();
            if (s.length() <= 0) {
                return new Date();
            }
            if (s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1).trim();
            }
            return new Date(Long.parseLong(s));
        }
        throw new IOException("JSON\u89e3\u6790\u306b\u5931\u6557(" + json + "):No:" + no);
    }

    private static final List<Object> analysisJsonToken(String json) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        int s = -1;
        int n = -1;
        int bef = -1;
        int len = json.length();
        for (int i = 0; i < len; ++i) {
            char c;
            char c2 = json.charAt(i);
            if (c != '\uffffffff') {
                if (bef != 92 && c == c2) {
                    ret.add(json.substring(s - 1, i + 1));
                    c = '\uffffffff';
                    s = i + 1;
                }
            } else if (bef != 92 && (c2 == '\'' || c2 == '\"')) {
                c = c2;
                if (s != -1 && s != i && bef != 32 && bef != 12288 && bef != 9 && bef != 10 && bef != 13) {
                    ret.add(json.substring(s, i + 1));
                }
                s = i + 1;
                bef = -1;
            } else if (c2 == '[' || c2 == ']' || c2 == '{' || c2 == '}' || c2 == '(' || c2 == ')' || c2 == ':' || c2 == ';' || c2 == ',' || c2 == '.' && (bef < 48 || bef > 57)) {
                if (s != -1 && s != i && bef != 32 && bef != 12288 && bef != 9 && bef != 10 && bef != 13) {
                    ret.add(json.substring(s, i));
                }
                ret.add(new String(new char[]{c2}));
                s = i + 1;
            } else if (c2 == ' ' || c2 == '\u3000' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                if (s != -1 && s != i && bef != 32 && bef != 12288 && bef != 9 && bef != 10 && bef != 13) {
                    ret.add(json.substring(s, i));
                }
                s = -1;
            } else if (s == -1) {
                s = i;
            }
            bef = c2;
        }
        return ret;
    }

    private static final Object createJsonInfo(int[] n, List<Object> token, int type, int no, int len) throws Exception {
        StringBuilder before = null;
        if (type == 0) {
            ArrayList<Object> ret = new ArrayList<Object>();
            boolean flg = false;
            for (int i = no + 1; i < len; ++i) {
                String value = (String)token.get(i);
                if (",".equals(value) || "]".equals(value)) {
                    if ("]".equals(value)) {
                        if (flg && before != null) {
                            ret.add(CryptoUtils_DecodeJSON.decJsonValue(n, i, before.toString()));
                        }
                        n[0] = i;
                        return ret;
                    }
                    if (flg) {
                        if (before == null) {
                            ret.add(null);
                        } else {
                            ret.add(CryptoUtils_DecodeJSON.decJsonValue(n, i, before.toString()));
                        }
                    }
                    before = null;
                    flg = false;
                    continue;
                }
                if ("[".equals(value)) {
                    ret.add(CryptoUtils_DecodeJSON.createJsonInfo(n, token, 0, i, len));
                    i = n[0];
                    before = null;
                    flg = false;
                    continue;
                }
                if ("{".equals(value)) {
                    ret.add(CryptoUtils_DecodeJSON.createJsonInfo(n, token, 1, i, len));
                    i = n[0];
                    before = null;
                    flg = false;
                    continue;
                }
                if (before == null) {
                    before = new StringBuilder();
                    before.append(value);
                } else {
                    before.append(" ").append(value);
                }
                flg = true;
            }
            n[0] = len - 1;
            return ret;
        }
        if (type == 1) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            String key = null;
            for (int i = no + 1; i < len; ++i) {
                String value = (String)token.get(i);
                if (":".equals(value)) {
                    if (key != null) continue;
                    throw new IOException("Map\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059(No:" + i + ")");
                }
                if (",".equals(value) || "}".equals(value)) {
                    if ("}".equals(value)) {
                        if (key != null) {
                            if (before == null) {
                                ret.put(key, null);
                            } else {
                                ret.put(key, CryptoUtils_DecodeJSON.decJsonValue(n, i, before.toString()));
                            }
                        }
                        n[0] = i;
                        return ret;
                    }
                    if (key == null) {
                        if (before == null) continue;
                        throw new IOException("Map\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059(No:" + i + ")");
                    }
                    if (before == null) {
                        ret.put(key, null);
                    } else {
                        ret.put(key, CryptoUtils_DecodeJSON.decJsonValue(n, i, before.toString()));
                    }
                    before = null;
                    key = null;
                    continue;
                }
                if ("[".equals(value)) {
                    if (key == null) {
                        throw new IOException("Map\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059(No:" + i + ")");
                    }
                    ret.put(key, CryptoUtils_DecodeJSON.createJsonInfo(n, token, 0, i, len));
                    i = n[0];
                    key = null;
                    before = null;
                    continue;
                }
                if ("{".equals(value)) {
                    if (key == null) {
                        throw new IOException("Map\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059(No:" + i + ")");
                    }
                    ret.put(key, CryptoUtils_DecodeJSON.createJsonInfo(n, token, 1, i, len));
                    i = n[0];
                    key = null;
                    before = null;
                    continue;
                }
                if (key == null) {
                    key = value;
                    if ((!key.startsWith("'") || !key.endsWith("'")) && (!key.startsWith("\"") || !key.endsWith("\""))) continue;
                    key = key.substring(1, key.length() - 1).trim();
                    continue;
                }
                if (before == null) {
                    before = new StringBuilder();
                    before.append(value);
                    continue;
                }
                before.append(" ").append(value);
            }
            n[0] = len - 1;
            return ret;
        }
        throw new IOException("JSON\u89e3\u6790\u306b\u5931\u6557(unknown)");
    }

    private static final String cutComment(String script) throws Exception {
        if (script == null || script.length() <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = script.length();
        int n = -1;
        int commentType = -1;
        int bef = -1;
        for (int i = 0; i < len; ++i) {
            char c;
            if (i != 0) {
                bef = script.charAt(i - 1);
            }
            char c2 = script.charAt(i);
            if (commentType != -1) {
                switch (commentType) {
                    case 1: {
                        if (c2 != '\n') break;
                        buf.append(c2);
                        commentType = -1;
                        break;
                    }
                    case 2: {
                        if (c2 == '\n') {
                            buf.append(c2);
                            break;
                        }
                        if (len <= i + 1 || c2 != '*' || script.charAt(i + 1) != '/') break;
                        ++i;
                        commentType = -1;
                    }
                }
                continue;
            }
            if (c != '\uffffffff') {
                if (c2 == c && (char)bef != '\\') {
                    c = '\uffffffff';
                }
                buf.append(c2);
                continue;
            }
            if (c2 == '/') {
                if (len <= i + 1) {
                    buf.append(c2);
                    continue;
                }
                char c22 = script.charAt(i + 1);
                if (c22 == '*') {
                    commentType = 2;
                    continue;
                }
                if (c22 == '/') {
                    commentType = 1;
                    continue;
                }
            } else if ((c2 == '\'' || c2 == '\"') && (char)bef != '\\') {
                c = c2 & 0xFFFF;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public static final boolean isNumber(int[] dot, Object o) {
        if (dot != null && dot.length > 0) {
            dot[0] = 0;
        }
        if (o instanceof Number) {
            if (dot != null && dot.length > 0) {
                if (o instanceof Double || o instanceof BigDecimal) {
                    dot[0] = 1;
                } else if (o instanceof Float) {
                    dot[0] = 2;
                }
            }
            return true;
        }
        if (dot != null && dot.length > 0) {
            dot[0] = 3;
        }
        return CryptoUtils_DecodeJSON.isNumberByString(dot, o);
    }

    private static final boolean isNumberByString(int[] dot, Object o) {
        String num = null;
        if (!(o instanceof String)) {
            return false;
        }
        num = (String)o;
        if (num == null || (num = num.trim()).length() <= 0) {
            return false;
        }
        int start = 0;
        if (num.startsWith("-")) {
            start = 1;
        }
        boolean dt = false;
        int len = num.length();
        if (start < len) {
            for (int i = start; i < len; ++i) {
                char c = num.charAt(i);
                if (c == '.') {
                    if (dt) {
                        return false;
                    }
                    if (dot != null && dot.length > 0) {
                        dot[0] = 4;
                    }
                    dt = true;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static final int indexByEquals(String base, String cc, int off) {
        int len = base.length();
        int n = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        char bef = '\u0000';
        boolean yenFlag = false;
        for (int i = off; i < len; ++i) {
            char c;
            char c2 = base.charAt(i);
            if (c != '\uffffffff') {
                if (bef != '\\' && c2 == c) {
                    yenFlag = false;
                    c = '\uffffffff';
                } else {
                    yenFlag = c2 == '\\' && bef == '\\';
                }
            } else if (bef != '\\' && (c2 == '\'' || c2 == '\"')) {
                c = c2;
            } else if (c2 == ck[0]) {
                boolean res = true;
                for (int j = 1; j < cLen; ++j) {
                    if (i + j < len && ck[j] == base.charAt(i + j)) continue;
                    res = false;
                    break;
                }
                if (res) {
                    return i;
                }
            }
            if (yenFlag) {
                yenFlag = false;
                bef = '\u0000';
                continue;
            }
            bef = c2;
        }
        return -1;
    }

    public static final int indexParAndCote(String base, char st, char ed, int off) throws Exception {
        int len = base.length();
        int par = -1;
        int n = -1;
        int idx = 0;
        int bef = 0;
        boolean yenFlag = false;
        for (int i = off; i < len; ++i) {
            char c;
            char c2 = base.charAt(i);
            if (par != -1 || c != '\uffffffff') {
                if (c != '\uffffffff') {
                    if (bef != 92 && c2 == c) {
                        yenFlag = false;
                        c = '\uffffffff';
                    } else {
                        yenFlag = c2 == '\\' && bef == 92;
                    }
                } else if (par != -1) {
                    if (c2 == ed) {
                        if (--idx <= 0) {
                            return i;
                        }
                    } else if (c2 == st) {
                        ++idx;
                    }
                }
            } else if (c2 == '\'' || c2 == '\"') {
                c = c2;
            } else if (c2 == st) {
                idx = 1;
                par = c2;
            } else if (c2 == ed) {
                return i;
            }
            if (yenFlag) {
                yenFlag = false;
                bef = 0;
                continue;
            }
            bef = c2;
        }
        return -1;
    }
}

