/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.crypto;

import org.maachang.crypto.CryptoUtils_BinaryBuffer;

class CryptoUtils {
    private CryptoUtils() {
    }

    public static final String convertUtf8ToBinary(String n) throws Exception {
        if (n == null || n.length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = n.length();
        CryptoUtils_BinaryBuffer buf = new CryptoUtils_BinaryBuffer(n.length() * 3);
        for (int i = len - 1; i >= 0; --i) {
            char c = n.charAt(i);
            if (c < '\u0080') {
                buf.write(c);
                continue;
            }
            if (c > '\u007f' && c < '\u0800') {
                buf.write(c & 0x3F | 0x80);
                buf.write(c >> 6 | 0xC0);
                continue;
            }
            buf.write(c & 0x3F | 0x80);
            buf.write(c >> 6 & 0x3F | 0x80);
            buf.write(c >> 12 | 0xE0);
        }
        byte[] lst = buf.getBinary();
        buf = null;
        len = lst.length;
        StringBuilder ret = new StringBuilder(len);
        for (int i = len - 1; i >= 0; --i) {
            ret.append((char)(lst[i] & 0xFF));
        }
        lst = null;
        return ret.toString();
    }

    public static final String convertBinaryToUTF8(String n) throws Exception {
        if (n == null || n.length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = n.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int c = n.charAt(i) & 0xFF;
            if (c < 128) {
                buf.append((char)c);
                continue;
            }
            if (c > 191 && c < 224) {
                buf.append((char)((c & 0x1F) << 6 | n.charAt(i + 1) & 0xFF & 0xFF & 0x3F));
                ++i;
                continue;
            }
            buf.append((char)((c & 0xF) << 12 | (n.charAt(i + 1) & 0xFF & 0xFF & 0x3F) << 6 | n.charAt(i + 2) & 0xFF & 0xFF & 0x3F));
            i += 2;
        }
        return buf.toString();
    }

    public static final int binaryIndexOf(byte[] binary, byte[] data, int off) throws Exception {
        return CryptoUtils.binaryIndexOf(binary, data, off, 0);
    }

    public static final int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        for (int i = off; i < len; ++i) {
            if (binary[i] != data[0] || i + dataLen > len) continue;
            ret = i;
            for (int j = 1; j < dataLen; ++j) {
                if (binary[i + j] == data[j]) continue;
                ret = -1;
                break;
            }
            if (ret == -1) continue;
            return ret;
        }
        return -1;
    }
}

