/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.crypto;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Map;
import org.maachang.crypto.CryptoRsaException;
import org.maachang.crypto.CryptoUtils;
import org.maachang.crypto.CryptoUtils_DecodeJSON;

public class CryptoRsaKey {
    private static final String RANDOM_TYPE = "SHA1PRNG";
    private static final ThreadLocal<SecureRandom> RAND = new ThreadLocal();
    protected BigInteger n = null;
    protected int e = 0;
    protected BigInteger d = null;
    protected BigInteger p = null;
    protected BigInteger q = null;
    protected BigInteger dmp1 = null;
    protected BigInteger dmq1 = null;
    protected BigInteger coeff = null;
    private static final byte[] _RSASIGN_DIHEAD_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] _RSASIGN_DIHEAD_SHA256 = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] _S_HEAD = new byte[]{0, 1};
    private static final Object[] _ALG_BIN_LIST = new Object[]{_RSASIGN_DIHEAD_SHA1, _RSASIGN_DIHEAD_SHA256};
    private static final String[] _ALG_NAME_LIST = new String[]{"sha1", "sha256"};

    public static final SecureRandom getRand() throws Exception {
        SecureRandom ret = RAND.get();
        if (ret == null) {
            ret = SecureRandom.getInstance(RANDOM_TYPE);
            RAND.set(ret);
        }
        return ret;
    }

    protected static final BigInteger pkcs1pad2(String s, int n) throws Exception {
        if (n < s.length() + 11) {
            throw new CryptoRsaException("Message too long for RSA (n=" + n + ", l=" + s.length() + ")");
        }
        byte[] ba = new byte[n];
        int i = s.length() - 1;
        while (i >= 0 && n > 0) {
            char c;
            if ((c = s.charAt(i--)) < '\u0080') {
                ba[--n] = (byte)c;
                continue;
            }
            if (c > '\u007f' && c < '\u0800') {
                ba[--n] = (byte)(c & 0x3F | 0x80);
                ba[--n] = (byte)(c >> 6 | 0xC0);
                continue;
            }
            ba[--n] = (byte)(c & 0x3F | 0x80);
            ba[--n] = (byte)(c >> 6 & 0x3F | 0x80);
            ba[--n] = (byte)(c >> 12 | 0xE0);
        }
        ba[--n] = 0;
        SecureRandom rng = CryptoRsaKey.getRand();
        byte[] x = new byte[1];
        while (n > 2) {
            x[0] = 0;
            while (x[0] == 0) {
                rng.nextBytes(x);
            }
            ba[--n] = x[0];
        }
        ba[--n] = 2;
        ba[--n] = 0;
        return new BigInteger(ba);
    }

    protected static final String pkcs1unpad2(BigInteger d, int n) throws Exception {
        int i;
        byte[] b = d.toByteArray();
        int bLen = b.length;
        for (i = 0; i < bLen && b[i] == 0; ++i) {
        }
        if (bLen - i != n - 1 || b[i] != 2) {
            return null;
        }
        ++i;
        while (b[i] != 0) {
            if (++i < bLen) continue;
            return null;
        }
        StringBuilder buf = new StringBuilder(bLen);
        while (++i < bLen) {
            int c = b[i] & 0xFF;
            if (c < 128) {
                buf.append((char)c);
                continue;
            }
            if (c > 191 && c < 224) {
                buf.append((char)((c & 0x1F) << 6 | b[i + 1] & 0x3F));
                ++i;
                continue;
            }
            buf.append((char)((c & 0xF) << 12 | (b[i + 1] & 0x3F) << 6 | b[i + 2] & 0x3F));
            i += 2;
        }
        return buf.toString();
    }

    public void setPublic(byte[] n, String e) throws Exception {
        if (n == null || n.length <= 0 || e == null || e.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.n = new BigInteger(n);
        this.e = Integer.parseInt(e, 16);
    }

    public void setPublic(String n, String e) throws Exception {
        if (n == null || n.length() <= 0 || e == null || e.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.n = new BigInteger(n, 16);
        this.e = Integer.parseInt(e, 16);
    }

    protected BigInteger doPublic(BigInteger x) throws Exception {
        return x.modPow(new BigInteger(String.valueOf(this.e)), this.n);
    }

    public void setPrivate(String n, String e, String d) throws Exception {
        if (n == null || n.length() <= 0 || e == null || e.length() <= 0 || d == null || d.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.n = new BigInteger(n, 16);
        this.e = Integer.parseInt(e, 16);
        this.d = new BigInteger(d, 16);
    }

    public void setPrivateEx(String n, String e, String d, String p, String q, String dp, String dq, String c) throws Exception {
        if (n == null || n.length() <= 0 || e == null || e.length() <= 0 || d == null || d.length() <= 0 || p == null || p.length() <= 0 || d == null || d.length() <= 0 || p == null || p.length() <= 0 || q == null || q.length() <= 0 || dp == null || dp.length() <= 0 || dq == null || dq.length() <= 0 || c == null || c.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.n = new BigInteger(n, 16);
        this.e = Integer.parseInt(e, 16);
        this.d = new BigInteger(d, 16);
        this.p = new BigInteger(p, 16);
        this.q = new BigInteger(q, 16);
        this.dmp1 = new BigInteger(dp, 16);
        this.dmq1 = new BigInteger(dq, 16);
        this.coeff = new BigInteger(c, 16);
    }

    protected BigInteger doPrivate(BigInteger x) throws Exception {
        if (this.p == null || this.q == null) {
            return x.modPow(this.d, this.n);
        }
        BigInteger xp = x.mod(this.p).modPow(this.dmp1, this.p);
        BigInteger xq = x.mod(this.q).modPow(this.dmq1, this.q);
        while (xp.compareTo(xq) < 0) {
            xp = xp.add(this.p);
        }
        return xp.subtract(xq).multiply(this.coeff).mod(this.p).multiply(this.q).add(xq);
    }

    protected void generate(int b, String e) throws Exception {
        BigInteger q1;
        BigInteger p1;
        BigInteger phi;
        SecureRandom rng = CryptoRsaKey.getRand();
        int qs = b >> 1;
        this.e = Integer.parseInt(e, 16);
        BigInteger ee = new BigInteger(e, 16);
        while (true) {
            this.p = new BigInteger(b - qs, 1, rng);
            if (this.p.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) != 0 || !this.p.isProbablePrime(10)) continue;
            do {
                this.q = new BigInteger(qs, 1, rng);
            } while (this.q.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) != 0 || !this.q.isProbablePrime(10));
            if (this.p.compareTo(this.q) <= 0) {
                BigInteger t = this.p;
                this.p = this.q;
                this.q = t;
            }
            if ((phi = (p1 = this.p.subtract(BigInteger.ONE)).multiply(q1 = this.q.subtract(BigInteger.ONE))).gcd(ee).compareTo(BigInteger.ONE) == 0) break;
        }
        this.n = this.p.multiply(this.q);
        this.d = ee.modInverse(phi);
        this.dmp1 = this.d.mod(p1);
        this.dmq1 = this.d.mod(q1);
        this.coeff = this.q.modInverse(this.p);
    }

    protected byte[] encrypt(String target) throws Exception {
        BigInteger m = CryptoRsaKey.pkcs1pad2(target, this.n.bitLength() + 7 >> 3);
        BigInteger c = this.doPublic(m);
        return c.toByteArray();
    }

    protected String decrypt(byte[] target) throws Exception {
        BigInteger c = new BigInteger(target);
        BigInteger m = this.doPrivate(c);
        return CryptoRsaKey.pkcs1unpad2(m, this.n.bitLength() + 7 >> 3);
    }

    protected static final byte[] convertHash(String hashAlg, byte[] b) throws Exception {
        MessageDigest md;
        if ("sha1".equals(hashAlg)) {
            md = MessageDigest.getInstance("sha-1");
        } else if ("sha256".equals(hashAlg)) {
            md = MessageDigest.getInstance("sha-256");
        } else {
            throw new CryptoRsaException("\u975e\u5bfe\u5fdc\u306e\u30cf\u30c3\u30b7\u30e5\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3067\u3059:" + hashAlg);
        }
        md.reset();
        md.update(b);
        return md.digest();
    }

    protected static final byte[] getDihead(String hashAlg) throws Exception {
        if ("sha1".equals(hashAlg)) {
            return _RSASIGN_DIHEAD_SHA1;
        }
        if ("sha256".equals(hashAlg)) {
            return _RSASIGN_DIHEAD_SHA256;
        }
        throw new CryptoRsaException("\u975e\u5bfe\u5fdc\u306e\u30cf\u30c3\u30b7\u30e5\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3067\u3059:" + hashAlg);
    }

    protected static final byte[] getHexPaddedDigestInfo(byte[] b, int keySize, String hashAlg) throws Exception {
        int pmBinLen = keySize >> 3;
        byte[] hash = CryptoRsaKey.convertHash(hashAlg, b);
        byte[] dihead = CryptoRsaKey.getDihead(hashAlg);
        byte[] sHead = _S_HEAD;
        int sTailLen = 1 + dihead.length + hash.length;
        int fLen = pmBinLen - sHead.length - sTailLen;
        byte[] ret = new byte[sHead.length + fLen + sTailLen];
        int p = 0;
        System.arraycopy(sHead, 0, ret, p, sHead.length);
        p += sHead.length;
        for (int i = 0; i < fLen; ++i) {
            ret[p] = -1;
            ++p;
        }
        ret[p] = 0;
        System.arraycopy(dihead, 0, ret, ++p, dihead.length);
        System.arraycopy(hash, 0, ret, p += dihead.length, hash.length);
        return ret;
    }

    protected BigInteger sign(byte[] b, String hashAlg) throws Exception {
        byte[] hPm = CryptoRsaKey.getHexPaddedDigestInfo(b, this.n.bitLength(), hashAlg);
        return this.doPrivate(new BigInteger(hPm));
    }

    protected static final Object[] getAlgNameAndHashFromHexDisgestInfo(byte[] info) throws Exception {
        int len = _ALG_BIN_LIST.length;
        for (int i = 0; i < len; ++i) {
            byte[] alg = (byte[])_ALG_BIN_LIST[i];
            int p = CryptoUtils.binaryIndexOf(info, alg, 0);
            if (p == -1) continue;
            return new Object[]{_ALG_NAME_LIST[i], p + alg.length};
        }
        return null;
    }

    protected boolean verify(byte[] sMsg, byte[] hSig) throws Exception {
        Object[] digestInfoAry;
        BigInteger biSig = new BigInteger(hSig);
        BigInteger biDecryptedSig = this.doPublic(biSig);
        byte[] hDigestInfo = biDecryptedSig.toByteArray();
        if (hDigestInfo[0] == 31 && hDigestInfo[1] == 0) {
            byte[] n = new byte[hDigestInfo.length - 2];
            System.arraycopy(hDigestInfo, 2, n, 0, n.length);
            hDigestInfo = n;
            n = null;
        }
        if ((digestInfoAry = CryptoRsaKey.getAlgNameAndHashFromHexDisgestInfo(hDigestInfo)) == null) {
            return false;
        }
        String algName = (String)digestInfoAry[0];
        int p = (Integer)digestInfoAry[1];
        byte[] hash = CryptoRsaKey.convertHash(algName, sMsg);
        return CryptoUtils.binaryIndexOf(hDigestInfo, hash, p) != -1;
    }

    protected static final String hexByte(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int cnt = b.length;
        for (int i = 0; i < cnt; ++i) {
            sb.append(Integer.toHexString(b[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(b[i] & 0xF));
        }
        return sb.toString();
    }

    public String encodeJSON() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("{n:");
        if (this.n == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.n.toString(16)).append("\",");
        }
        buf.append(" e:").append(this.e).append(",");
        buf.append("d:");
        if (this.d == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.d.toString(16)).append("\",");
        }
        buf.append("p:");
        if (this.p == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.p.toString(16)).append("\",");
        }
        buf.append("q:");
        if (this.q == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.q.toString(16)).append("\",");
        }
        buf.append("dmp1:");
        if (this.dmp1 == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.dmp1.toString(16)).append("\",");
        }
        buf.append("dmq1:");
        if (this.dmq1 == null) {
            buf.append("null,");
        } else {
            buf.append("\"").append(this.dmq1.toString(16)).append("\",");
        }
        buf.append("coeff:");
        if (this.coeff == null) {
            buf.append("null}");
        } else {
            buf.append("\"").append(this.coeff.toString(16)).append("\"}");
        }
        return buf.toString();
    }

    public static final CryptoRsaKey decodeJSON(String json) throws Exception {
        if (json == null || json.length() <= 0) {
            throw new IllegalArgumentException("json\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Map m = (Map)CryptoUtils_DecodeJSON.execution(json);
        CryptoRsaKey ret = new CryptoRsaKey();
        if (m.get("n") != null) {
            ret.n = new BigInteger((String)m.get("n"), 16);
        }
        ret.e = m.get("e") instanceof Integer ? (Integer)m.get("e") : Integer.parseInt((String)m.get("e"));
        if (m.get("d") != null) {
            ret.d = new BigInteger((String)m.get("d"), 16);
        }
        if (m.get("p") != null) {
            ret.p = new BigInteger((String)m.get("p"), 16);
        }
        if (m.get("q") != null) {
            ret.q = new BigInteger((String)m.get("q"), 16);
        }
        if (m.get("dmp1") != null) {
            ret.dmp1 = new BigInteger((String)m.get("dmp1"), 16);
        }
        if (m.get("dmq1") != null) {
            ret.dmq1 = new BigInteger((String)m.get("dmq1"), 16);
        }
        if (m.get("coeff") != null) {
            ret.coeff = new BigInteger((String)m.get("coeff"), 16);
        }
        return ret;
    }
}

