package org.maachang.jni.io ;

/**
 * 高速MemoryBuffer.
 * <p>このバッファは、速度重視を考慮した、チェック処理なしで、
 *    Nativeメモリにアクセスするオブジェクトです.
 *    欠点として、ダイレクトにNativeメモリにアクセスするので、
 *    このオブジェクトによって操作した結果によって、処理異常が
 *    発生した場合、最悪JavaVMが異常停止してしまいます.</p>
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public class FastMemoryBuffer
    extends AbstractFastNativeBuffer implements NormalBuffer {
    private FastMemoryBuffer() {
        
    }
    
    /**
     * コンストラクタ.
     * @param length Native生成するメモリサイズを設定します.
     */
    public FastMemoryBuffer( int length ) {
        create( length ) ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        clear() ;
    }
    
    /**
     * メモリ生成.
     * @param length Native生成するメモリサイズを設定します.
     */
    public void create( int length ) {
        if( length <= 0 ) {
            throw new IllegalArgumentException( "メモリサイズが不正です" ) ;
        }
        clear() ;
        this.address = NativeIO.malloc( length ) ;
        this.length = length ;
    }
    
    /**
     * メモリクリア.
     */
    public void clear() {
        if( address != 0L ) {
            NativeIO.free( address ) ;
            address = 0L ;
            length = 0 ;
        }
    }
    
    /**
     * メモリ領域再生成.
     * @param length 再生成するメモリサイズを設定します.
     */
    public void reCreate( int length ) {
        if( length <= 0 ) {
            throw new IllegalArgumentException( "メモリサイズが不正です" ) ;
        }
        if( this.address == 0L ) {
            throw new IllegalStateException( "既にクリアされています" ) ;
        }
        this.address = NativeIO.realloc( address,length ) ;
        this.length = length ;
    }
    
}

