/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.io.InputStream;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.MmapBufferImpl;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeIODefine;
import org.maachang.jni.io.NotFileException;

public class NativeMmapInputStream
extends InputStream {
    private static final int ACCESS_MODE = 1;
    private static final int IO_OPT = 0;
    private long address = 0L;
    private long mmapHandle = -1L;
    private int mmapLength = 0;
    private int position = 0;
    private long handle = -1L;
    private long fileSize = 0L;

    private NativeMmapInputStream() {
    }

    public NativeMmapInputStream(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!NativeIODefine.useFile(name)) {
            throw new NotFileException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        name = NativeIODefine.fullPath(name);
        this.handle = NativeIO.open(1, 0, 0, NativeIODefine.nativeString(name));
        if (this.handle == -1L) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.fileSize = NativeIO.getLength(this.handle);
        if (this.fileSize >= Integer.MAX_VALUE) {
            this.close();
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u304c\u5927\u304d\u3059\u304e\u308b\u306e\u3067\u3001mmap\u3067\u304d\u307e\u305b\u3093");
        }
        this.createMmap();
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.handle > -1L) {
            this.clearMmap();
            NativeIO.close(this.handle);
            this.handle = -1L;
            this.position = 0;
            this.fileSize = -1L;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return (int)(this.fileSize - (long)this.position & Integer.MAX_VALUE);
    }

    @Override
    public int read() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.fileSize <= (long)this.position) {
            return -1;
        }
        int ret = DirectMemoryIO.get(this.address, this.position) & 0xFF;
        ++this.position;
        return ret;
    }

    public long getAddress() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.address;
    }

    public int getLength() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return (int)this.fileSize;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    protected void createMmap() throws IOException {
        long[] out = new long[2];
        int len = MmapBufferImpl.getLengthToPageSize((int)this.fileSize);
        if (NativeIO.createMmap(out, this.handle, 1, 0L, len) != 0) {
            throw new IOException("Mmap\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.address = out[0];
        this.mmapHandle = out[1];
        this.mmapLength = len;
    }

    protected void clearMmap() {
        if (this.address != 0L) {
            NativeIO.closeMmap(this.mmapHandle, this.address, this.mmapLength);
            this.address = 0L;
            this.mmapHandle = -1L;
            this.mmapLength = 0;
        }
    }

    public long length() throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.fileSize;
    }
}

