/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.Unsafe;

public final class FastDirectMemoryIO {
    private static final boolean UnsafeMode = Unsafe.UNSAFE_MODE;
    private static final sun.misc.Unsafe unsafe = Unsafe.unsafe;

    private FastDirectMemoryIO() {
    }

    public static final byte get(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index);
        }
        return NativeIO.getByte(address + (long)index);
    }

    public static final void put(long address, int index, byte value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value);
        } else {
            NativeIO.putByte(address + (long)index, value);
        }
    }

    public static int putBinary(long address, int index, byte[] value, int offset, int length) {
        NativeIO.putBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static int getBinary(long address, int index, byte[] value, int offset, int length) {
        NativeIO.getBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static void putBoolean(long address, int index, boolean value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value ? (byte)1 : 0);
        } else {
            NativeIO.putByte(address + (long)index, value ? (byte)1 : 0);
        }
    }

    public static boolean getBoolean(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index) != 0;
        }
        return NativeIO.getByte(address + (long)index) != 0;
    }

    public static void putChar(long address, int index, char value) {
        if (UnsafeMode) {
            unsafe.putChar(address + (long)index, value);
        } else {
            NativeIO.putChar(address + (long)index, value);
        }
    }

    public static char getChar(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getChar(address + (long)index);
        }
        return NativeIO.getChar(address + (long)index);
    }

    public static void putShort(long address, int index, short value) {
        if (UnsafeMode) {
            unsafe.putShort(address + (long)index, value);
        } else {
            NativeIO.putShort(address + (long)index, value);
        }
    }

    public static short getShort(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getShort(address + (long)index);
        }
        return NativeIO.getShort(address + (long)index);
    }

    public static void putInt(long address, int index, int value) {
        if (UnsafeMode) {
            unsafe.putInt(address + (long)index, value);
        } else {
            NativeIO.putInt(address + (long)index, value);
        }
    }

    public static int getInt(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getInt(address + (long)index);
        }
        return NativeIO.getInt(address + (long)index);
    }

    public static void putLong(long address, int index, long value) {
        if (UnsafeMode) {
            unsafe.putLong(address + (long)index, value);
        } else {
            NativeIO.putLong(address + (long)index, value);
        }
    }

    public static long getLong(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getLong(address + (long)index);
        }
        return NativeIO.getLong(address + (long)index);
    }

    public static void putFloat(long address, int index, float value) {
        FastDirectMemoryIO.putInt(address, index, Float.floatToIntBits(value));
    }

    public static float getFloat(long address, int index) {
        return Float.intBitsToFloat(FastDirectMemoryIO.getInt(address, index));
    }

    public static void putDouble(long address, int index, double value) {
        FastDirectMemoryIO.putLong(address, index, Double.doubleToLongBits(value));
    }

    public static double getDouble(long address, int index) {
        return Double.longBitsToDouble(FastDirectMemoryIO.getLong(address, index));
    }
}

