/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.Unsafe;

public final class DirectMemoryIO {
    private static final boolean UnsafeMode = Unsafe.UNSAFE_MODE;
    private static final sun.misc.Unsafe unsafe = Unsafe.unsafe;
    protected static final boolean BIG_ENDIAN = Unsafe.BIG_ENDIAN;

    private DirectMemoryIO() {
    }

    public static final long malloc(int size) {
        return NativeIO.malloc(size);
    }

    public static final long realloc(long address, int size) {
        return NativeIO.realloc(address, size);
    }

    public static final long realloc(long address, int srcSize, int size) {
        long ret = NativeIO.malloc(size);
        if (size > srcSize) {
            NativeIO.memset(ret, (byte)0, size);
            NativeIO.memcpy(ret, address, srcSize);
        } else {
            NativeIO.memcpy(ret, address, size);
        }
        NativeIO.free(address);
        return ret;
    }

    public static final void free(long address) {
        NativeIO.free(address);
    }

    public static final void memset(long address, byte code, int size) {
        NativeIO.memset(address, code, size);
    }

    public static final void memcpy(long destAddr, long srcAddr, int size) {
        NativeIO.memcpy(destAddr, srcAddr, size);
    }

    public static final byte get(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index);
        }
        return NativeIO.getByte(address + (long)index);
    }

    public static final void put(long address, int index, byte value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value);
        } else {
            NativeIO.putByte(address + (long)index, value);
        }
    }

    public static int putBinary(long address, int index, byte[] value, int offset, int length) {
        NativeIO.putBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static int getBinary(long address, int index, byte[] value, int offset, int length) {
        NativeIO.getBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static void putBoolean(long address, int index, boolean value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value ? (byte)1 : 0);
        } else {
            NativeIO.putByte(address + (long)index, value ? (byte)1 : 0);
        }
    }

    public static boolean getBoolean(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index) != 0;
        }
        return NativeIO.getByte(address + (long)index) != 0;
    }

    public static void putChar(long address, int index, char value) {
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putChar(address + (long)index, value);
        } else {
            NativeIO.putChar(address + (long)index, value);
        }
    }

    public static char getChar(long address, int index) {
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getChar(address + (long)index);
            }
            return Unsafe.swap(unsafe.getChar(address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getChar(address + (long)index);
        }
        return Unsafe.swap(NativeIO.getChar(address + (long)index));
    }

    public static void putShort(long address, int index, short value) {
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putShort(address + (long)index, value);
        } else {
            NativeIO.putShort(address + (long)index, value);
        }
    }

    public static short getShort(long address, int index) {
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getShort(address + (long)index);
            }
            return Unsafe.swap(unsafe.getShort(address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getShort(address + (long)index);
        }
        return Unsafe.swap(NativeIO.getShort(address + (long)index));
    }

    public static void putInt(long address, int index, int value) {
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putInt(address + (long)index, value);
        } else {
            NativeIO.putInt(address + (long)index, value);
        }
    }

    public static int getInt(long address, int index) {
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getInt(address + (long)index);
            }
            return Unsafe.swap(unsafe.getInt(address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getInt(address + (long)index);
        }
        return Unsafe.swap(NativeIO.getInt(address + (long)index));
    }

    public static void putLong(long address, int index, long value) {
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putLong(address + (long)index, value);
        } else {
            NativeIO.putLong(address + (long)index, value);
        }
    }

    public static long getLong(long address, int index) {
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getLong(address + (long)index);
            }
            return Unsafe.swap(unsafe.getLong(address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getLong(address + (long)index);
        }
        return Unsafe.swap(NativeIO.getLong(address + (long)index));
    }

    public static void putFloat(long address, int index, float value) {
        DirectMemoryIO.putInt(address, index, Float.floatToIntBits(value));
    }

    public static float getFloat(long address, int index) {
        return Float.intBitsToFloat(DirectMemoryIO.getInt(address, index));
    }

    public static void putDouble(long address, int index, double value) {
        DirectMemoryIO.putLong(address, index, Double.doubleToLongBits(value));
    }

    public static double getDouble(long address, int index) {
        return Double.longBitsToDouble(DirectMemoryIO.getLong(address, index));
    }

    public static final boolean equals(long srcAddr, int srcOff, long destAddr, int destOff, int length) {
        return NativeIO.equalsBinary(srcAddr + (long)srcOff, destAddr + (long)destOff, length) == 1;
    }

    public static final long fnv64(long address, int offset, int length) {
        return NativeIO.fnv64(address + (long)offset, length);
    }

    public static final int indexOf(long address, int index, int length, byte[] binary) {
        int len;
        if (binary == null || (len = binary.length) <= 0) {
            return -1;
        }
        if (index < 0 || index + len > length) {
            return -1;
        }
        int ret = NativeIO.indexOf(address + (long)index, length - index, binary, len);
        if (ret == -1) {
            return -1;
        }
        return ret + index;
    }

    public static final int lastIndexOf(long address, int index, int length, byte[] binary) {
        int len;
        if (binary == null || (len = binary.length) <= 0) {
            return -1;
        }
        if (index >= length) {
            index = length - 1;
        } else if (index - len < 0) {
            return -1;
        }
        return NativeIO.lastIndexOf(address, index, length, binary, len);
    }

    public static final boolean compact(long address, int index, int length, int moveLength) {
        if (length <= 0 || index <= 0 || index + moveLength >= length) {
            return false;
        }
        NativeIO.compact(address, length, index, moveLength);
        return true;
    }
}

