/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.Unsafe;

public abstract class AbstractNativeBuffer
implements NativeBuffer {
    protected static final boolean BIG_ENDIAN = Unsafe.BIG_ENDIAN;
    protected static final boolean UnsafeMode = Unsafe.UNSAFE_MODE;
    protected static final sun.misc.Unsafe unsafe = Unsafe.unsafe;
    protected long address = 0L;
    protected int length = 0;
    private static final int BINARY_COPY_TO_PUT_BYTE = 8;

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isClear() {
        return this.address == 0L;
    }

    protected void check(boolean mode) {
    }

    @Override
    public void putByte(int index, byte value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (UnsafeMode) {
            unsafe.putByte(this.address + (long)index, value);
        } else {
            NativeIO.putByte(this.address + (long)index, value);
        }
    }

    @Override
    public byte getByte(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            return unsafe.getByte(this.address + (long)index);
        }
        return NativeIO.getByte(this.address + (long)index);
    }

    @Override
    public int putBinary(int index, byte[] value, int offset, int length) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index + length > this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("\u7bc4\u56f2\u5916\u306e\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + " offset:" + offset + " length:" + length + ")");
        }
        if (length == 0) {
            return 0;
        }
        this.check(true);
        if (length <= 8) {
            if (UnsafeMode) {
                long j = (long)index + this.address;
                int i = offset;
                while (i < length) {
                    unsafe.putByte(j, value[i]);
                    ++i;
                    ++j;
                }
            } else {
                long j = (long)index + this.address;
                int i = offset;
                while (i < length) {
                    NativeIO.putByte(j, value[i]);
                    ++i;
                    ++j;
                }
            }
            return length;
        }
        NativeIO.putBinary(this.address + (long)index, value, offset, length);
        return length;
    }

    @Override
    public int getBinary(int index, byte[] value, int offset, int length) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index + length > this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("\u7bc4\u56f2\u5916\u306e\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + " offset:" + offset + " length:" + length + ")");
        }
        if (length == 0) {
            return 0;
        }
        this.check(false);
        if (length <= 8) {
            if (UnsafeMode) {
                long j = (long)index + this.address;
                int i = offset;
                while (i < length) {
                    value[i] = unsafe.getByte(j);
                    ++i;
                    ++j;
                }
            } else {
                long j = (long)index + this.address;
                int i = offset;
                while (i < length) {
                    value[i] = NativeIO.getByte(j);
                    ++i;
                    ++j;
                }
            }
            return length;
        }
        NativeIO.getBinary(this.address + (long)index, value, offset, length);
        return length;
    }

    @Override
    public void putBoolean(int index, boolean value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (UnsafeMode) {
            unsafe.putByte(this.address + (long)index, value ? (byte)1 : 0);
        } else {
            NativeIO.putByte(this.address + (long)index, value ? (byte)1 : 0);
        }
    }

    @Override
    public boolean getBoolean(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            return unsafe.getByte(this.address + (long)index) != 0;
        }
        return NativeIO.getByte(this.address + (long)index) != 0;
    }

    @Override
    public void putChar(int index, char value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 1 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putChar(this.address + (long)index, value);
        } else {
            NativeIO.putChar(this.address + (long)index, value);
        }
    }

    @Override
    public char getChar(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 1 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getChar(this.address + (long)index);
            }
            return Unsafe.swap(unsafe.getChar(this.address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getChar(this.address + (long)index);
        }
        return Unsafe.swap(NativeIO.getChar(this.address + (long)index));
    }

    @Override
    public void putShort(int index, short value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 1 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putShort(this.address + (long)index, value);
        } else {
            NativeIO.putShort(this.address + (long)index, value);
        }
    }

    @Override
    public short getShort(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 1 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getShort(this.address + (long)index);
            }
            return Unsafe.swap(unsafe.getShort(this.address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getShort(this.address + (long)index);
        }
        return Unsafe.swap(NativeIO.getShort(this.address + (long)index));
    }

    @Override
    public void putInt(int index, int value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 3 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putInt(this.address + (long)index, value);
        } else {
            NativeIO.putInt(this.address + (long)index, value);
        }
    }

    @Override
    public int getInt(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 3 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getInt(this.address + (long)index);
            }
            return Unsafe.swap(unsafe.getInt(this.address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getInt(this.address + (long)index);
        }
        return Unsafe.swap(NativeIO.getInt(this.address + (long)index));
    }

    @Override
    public void putLong(int index, long value) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 7 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(true);
        if (!BIG_ENDIAN) {
            value = Unsafe.swap(value);
        }
        if (UnsafeMode) {
            unsafe.putLong(this.address + (long)index, value);
        } else {
            NativeIO.putLong(this.address + (long)index, value);
        }
    }

    @Override
    public long getLong(int index) {
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (index < 0 || index + 7 >= this.length) {
            throw new IllegalArgumentException("\u7bc4\u56f2\u5916\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059(index:" + index + " memoryLength:" + this.length + ")");
        }
        this.check(false);
        if (UnsafeMode) {
            if (BIG_ENDIAN) {
                return unsafe.getLong(this.address + (long)index);
            }
            return Unsafe.swap(unsafe.getLong(this.address + (long)index));
        }
        if (BIG_ENDIAN) {
            return NativeIO.getLong(this.address + (long)index);
        }
        return Unsafe.swap(NativeIO.getLong(this.address + (long)index));
    }

    @Override
    public void putFloat(int index, float value) {
        this.putInt(index, Float.floatToIntBits(value));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public void putDouble(int index, double value) {
        this.putLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public int indexOf(byte[] binary) {
        return this.indexOf(binary, 0);
    }

    @Override
    public int indexOf(byte[] binary, int index) {
        int len;
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (binary == null || (len = binary.length) <= 0) {
            return -1;
        }
        if (index < 0 || index + len > this.length) {
            return -1;
        }
        this.check(false);
        int ret = NativeIO.indexOf(this.address + (long)index, this.length - index, binary, len);
        if (ret == -1) {
            return -1;
        }
        return ret + index;
    }

    @Override
    public int lastIndexOf(byte[] binary) {
        return this.lastIndexOf(binary, this.length - 1);
    }

    @Override
    public int lastIndexOf(byte[] binary, int index) {
        int len;
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (binary == null || (len = binary.length) <= 0) {
            return -1;
        }
        if (index < 0 || index + len > this.length) {
            return -1;
        }
        this.check(false);
        return NativeIO.lastIndexOf(this.address, index, this.length, binary, len);
    }
}

