package jp.gr.java_conf.matoba.tools.ant;

import java.util.Vector;
import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

import jp.gr.java_conf.matoba.io.FileUtil;

/**
 * SmartDoc̎ssB<BR>
 *
 *
 * 
 * <ul>
 * <li>srcdir</li>
 * <li>destdir</li>
 * <li>includes</li>
 * <li>excludes</li>
 * <li>packager</li>
 * <li>verbose</li>
 * <li>toc</li>
 * <li>index</li>
 * <li>locale</li>
 * <li>masterLocale</li>
 * <li>format</li>
 * <li>split</li>
 * <li>options</li>
 * </ul>
 *
 * @see jp.gr.java_conf.jaba2.SmartDoc.SmartDoc
 * @author T.Matoba(matoba@tosco.co.jp)
 * @version 0.1
 *
 */

public class SmartDocTask extends Task {

    /** RpCs̃G[bZ[W */
    private static final String FAIL_MSG
        = "Compile failed, messages should have been provided.";
    protected boolean failOnError = true;

    private File destdir;
    private boolean verbose = false;
    private boolean toc = false;
    private boolean index = false;
    private String locale = "";
    private String masterLocale = "";
    private String format = "";
    private String packager = "";
    private String split = "";
    private String options = "";
    private FileSet fileSet = new FileSet();

    /**
     * ^XN̎ssB
     * @throws BuildException sɎsꍇ
     */
    public void execute() throws BuildException {
        // o̓fBNg܂̓fBNgłȂꍇ
        // (݂́Ao͖͐Ή)
//      if (destdir == null || !destdir.isDirectory()) {
//          throw new BuildException("destination directory \"" + destdir
//              + "\" does not exist or is not a directory", location);
//      }

        // \[XfBNgXLARpCׂt@CT
        DirectoryScanner ds = fileSet.getDirectoryScanner(project);
        ds.scan();

        String[] compileList = ds.getIncludedFiles();

        if (compileList.length > 0) {
            // p[^̍쐬
            String[] parameters = createParameters();
            String currentDir = FileUtil.getCurrentDirectory();

            try{
                for(int i=0;i < compileList.length;i++){
                    parameters[parameters.length-1] =
                        fileSet.getDir(project).getPath()
                        + File.separator + compileList[i];
                    FileUtil.changeCurrentDirectory(
                        new File(parameters[parameters.length-1]).getParent());
                    run(parameters);
                }
            }
            catch(Exception e){
                // RpCs
                e.printStackTrace();
                throw new BuildException(FAIL_MSG);
            }
            finally{
                // ̃JgfBNgɖ߂
                FileUtil.changeCurrentDirectory(currentDir);
            }
        }
    }

    /**
     * \[XfBNgݒ肷B
     * @param srcDir \[XfBNg
     */
    public void setSrcdir(File srcDir) {
        fileSet.setDir(srcDir);
    }
    /**
     * o̓fBNgݒ肷B
     * @param destdir o̓fBNg
     */
    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }
    /**
     * sΏۂƂȂt@Cݒ肷B
     * @param includes sΏۂƂȂt@C
     */
    public void setIncludes(String includes) {
        fileSet.setIncludes(includes);
    }
    /**
     * sΏۂOt@Cw肷B
     * @param excludes sΏۂOt@C
     */
    public void setExcludes(String excludes) {
        fileSet.setExcludes(excludes);
    }
    /**
     * ڍ׃bZ[W̕\/\ݒ肷B
     * @param verbose true:ڍ׃bZ[W\/flase:\
     */
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
    /**
     * ڎ̏o͂̐ݒsB
     * @param toc true:ڎo͂/false:o͂Ȃ
     */
    public void setToc(boolean toc) {
        this.toc = toc;
    }
    /**
     * ̏o͂̐ݒsB
     * @param index true:o͂/flase:o͂Ȃ
     */
    public void setIndex(boolean index) {
        this.index = index;
    }
   public void setLocale(String locale) {
        this.locale = locale;
    }
    public void setMasterLocale(String masterLocale) {
        this.masterLocale = masterLocale;
    }
    public void setFormat(String format) {
        this.format = format;
    }
    public void setPackager(String packager) {
        this.packager = packager;
    }
    public void setSplit(String split) {
        this.split = split;
    }
    public void setOptions(String options) {
        this.options = options;
    }

    private void run(String[] args) throws Exception{
        jp.gr.java_conf.jaba2.SmartDoc.SmartDoc app
            = new jp.gr.java_conf.jaba2.SmartDoc.SmartDoc(args);
        app.start();
    }

    // ݒ肳Ă鑮p[^̍쐬s
    private String[] createParameters(){
        Vector  parameterList = new Vector();
        if(verbose){
            parameterList.add("-verbose");
        }
        if(toc){
            parameterList.add("-toc");
        }
        if(index){
            parameterList.add("-index");
        }
        if(!"".equals(locale)){
            parameterList.add("-locale:"+locale);
        }
        if(!"".equals(masterLocale)){
            parameterList.add("-masterLocale:"+masterLocale);
        }
        if(!"".equals(format)){
            parameterList.add("-format:"+format);
        }
        if(!"".equals(packager)){
            parameterList.add("-packager:"+packager);
        }
        if(!"".equals(split)){
            parameterList.add("-split:"+split);
        }
        java.util.StringTokenizer st = new java.util.StringTokenizer(options);
        while(st.hasMoreTokens()){
            parameterList.add(st.nextToken());
        }

        String[] parameters = new String[parameterList.size()+1];
        System.arraycopy(parameterList.toArray(), 0,
            parameters, 0, parameterList.size());
        return parameters;
    }
}
