﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Framework;
using Framework.Data;
using Framework.Web.UI.CompositeControls;
using Framework.DB.SqlServerCe;

namespace Sample1.Master
{
    public class AppSettingDb : DbAccessBase
    {
        /// <summary>
        /// tblに全件をFillします。
        /// </summary>
        /// <param name="tbl"></param>
        public void FillData(Framework.Data.AppSettingDataSet ds)
        {
            var sql = @"
                SELECT APPSETTING_KEY as [Key]
                     , VALUE as Value
                  FROM TM_APPSETTING
                ";

            base.FillDataTable(ds.AppSetting, sql);
        }

        /// <summary>
        /// データソースリクエスト
        /// </summary>
        /// <param name="e"></param>
        /// <param name="data"></param>
        public void ReqestGridViewSrc(GridViewSrcRequestEventArgs e, MappingData data)
        {
            var select = @"
                |SELECT APPSETTING_KEY
                |     , VALUE
                |     , CONVERT(bigint, ROW_VER) ROW_VER
                ".StripMargin();

            var where = @"
                |  FROM TM_APPSETTING
                | WHERE 1 = 1
                ".StripMargin();

            if (data["APPSETTING_KEY"].IsNotBlank() == true)
            {
                where += " AND APPSETTING_KEY = @APPSETTING_KEY";
            }
            if (data["S_APPSETTING_KEY"].IsNotBlank() == true)
            {
                where += " AND APPSETTING_KEY LIKE '%' + @S_APPSETTING_KEY + '%'";
            }


            //総件数の取得
            string sqlCnt = "SELECT COUNT(*) " + where;
            e.TotalRecords = (int)base.ExecuteScalar(sqlCnt, data);

            //データ取得
            var sql = @"
                |{0}
                |{1}
                |ORDER BY {2}
                |OFFSET {3} ROWS
                |FETCH NEXT {4} ROWS ONLY
                ".StripMargin()
                 .Fmt(select, where, e.SortExpression, e.StartRecord - 1, e.MaxRecords);
            e.DataSource = base.GetDataTable(sql, data).DefaultView;
        }

        /// <summary>
        /// Update
        /// </summary>
        /// <param name="data"></param>
        /// <returns>更新件数</returns>
        public int Update(GridViewPagerUpdateEventArgs e, Framework.Data.MappingData data)
        {
            var sql = @"
                |UPDATE TM_APPSETTING
                |   SET APPSETTING_KEY = @APPSETTING_KEY
                |     , VALUE = @VALUE
                | WHERE CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                //更新
                cnt = base.ExecuteNonQuery(sql, data);

                if (cnt > 0)
                {
                    //更新後のデータ取得
                    var re = new GridViewSrcRequestEventArgs(1, 1, "APPSETTING_KEY");
                    this.ReqestGridViewSrc(re, data);
                    e.NewValues = re.DataSource[0];
                }
            });

            return cnt;
        }

        /// <summary>
        /// Insert
        /// </summary>
        /// <param name="data"></param>
        public int Insert(MappingData data)
        {
            var sqlChk = @"
                |SELECT COUNT(*)
                |  FROM TM_APPSETTING
                | WHERE APPSETTING_KEY = @APPSETTING_KEY
                ".StripMargin();

            var sql = @"
                |INSERT INTO TM_APPSETTING
                |     ( APPSETTING_KEY
                |     , VALUE )
                |VALUES
                |     ( @APPSETTING_KEY
                |     , @VALUE )
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                if ((int)base.ExecuteScalar(sqlChk, data) == 0)
                {
                    cnt = base.ExecuteNonQuery(sql, data);
                }
            });

            return cnt;
        }

        /// <summary>
        /// Delete
        /// </summary>
        /// <param name="data"></param>
        /// <returns>削除件数</returns>
        public int Delete(MappingData data)
        {
            var sql = @"
                |DELETE FROM TM_APPSETTING
                | WHERE CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                cnt = base.ExecuteNonQuery(sql, data);
            });

            return cnt;
        }
    }
}