﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Framework.DB.SqlServerCe
{
    /// <summary>
    /// 主にDBへの接続を管理するクラスです。
    /// </summary>
    public class DbMgr
    {
        /// <summary>
        /// デフォルトの接続文字列のNameを返します。
        /// </summary>
        public static string DefaultConnectionStringName = "ConnectionString";

        /// <summary>
        /// デフォルトの接続文字列を返します。("ConnectionString")
        /// </summary>
        /// <returns></returns>
        public static string GetConnectionString()
        {
            return GetConnectionString(DefaultConnectionStringName);
        }

        /// <summary>
        /// デフォルトの接続文字列のコネクションを返します。
        /// </summary>
        /// <returns></returns>
        public static System.Data.SqlServerCe.SqlCeConnection GetConnection()
        {
            return GetConnection(DefaultConnectionStringName);
        }

        /// <summary>
        /// 指定したkeyの接続文字列を返します。
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetConnectionString(string key)
        {
            return Framework.Data.AppSetting.GetConnectionString(key);
        }

        /// <summary>
        /// 指定したkeyの接続文字列のコネクションを返します。
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static System.Data.SqlServerCe.SqlCeConnection GetConnection(string key)
        {
            return new System.Data.SqlServerCe.SqlCeConnection(GetConnectionString(key));
        }
    }
}
