﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// ローカライズ機能を持ったリンクボタン
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:LLinkButton runat=server></{0}:LLinkButton>")]
    public class LLinkButton : LinkButton, ILocalizeControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        /// <summary>
        /// trueの場合は2度押し機能が有効になります
        /// </summary>
        [Category("Custom")]
        [DefaultValue("true")]
        public bool Stop2ndPost { get; set; }

        private bool IsClientClickRegistered
        {
            get { return (bool?)ViewState["IsClientClickRegistered"] ?? false; }
            set { ViewState["IsClientClickRegistered"] = value; }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LLinkButton()
        {
            Stop2ndPost = true;
        }

        /// <summary>
        /// OnPreRender
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPreRender(System.EventArgs e)
        {
            if (this.IsClientClickRegistered == false)
            {
                var script = this.OnClientClick;
                this.OnClientClick = "";

                //2度押し防止スクリプトを登録
                if (this.Stop2ndPost == true)
                {
                    JavaScript.RegisterStop2ndPost(this);
                }

                this.OnClientClick += script;

                this.IsClientClickRegistered = true;
            }

            //OnPreRender
            base.OnPreRender(e);
        }

        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
