﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    [DefaultProperty("LTextKey")]
    [ToolboxData("<{0}:LButton runat=server></{0}:LButton>")]
    public class LButton : Button, ILocalizeControl
    {
        /// <summary>
        /// テキストのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        /// <summary>
        /// 確認ダイアログのメッセージのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string ConfirmLTextKey { get; set; }

        /// <summary>
        /// trueの場合は2度押し機能が有効になります
        /// </summary>
        [Category("Custom")]
        [DefaultValue("true")]
        public bool Stop2ndPost { get; set; }

        private bool IsClientClickRegistered
        {
            get { return (bool?)ViewState["IsClientClickRegistered"] ?? false; }
            set { ViewState["IsClientClickRegistered"] = value; }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LButton()
        {
            //「ENTER」キーによるSubmitを無効にさせるための処理
            base.UseSubmitBehavior = false;

            this.Stop2ndPost = true;
        }

        /// <summary>
        /// OnPreRender
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPreRender(EventArgs e)
        {
            if (this.IsClientClickRegistered == false)
            {
                var script = this.OnClientClick;
                this.OnClientClick = "";

                //2度押し防止スクリプトを登録
                if (this.Stop2ndPost == true)
                {
                    JavaScript.RegisterStop2ndPost(this);
                }

                this.OnClientClick += script;

                //確認ダイアログを登録
                if (this.ConfirmLTextKey.IsNotBlank())
                {
                    JavaScript.RegisterConfirm(this, LTextMgr.GetText(this.ConfirmLTextKey));
                }

                this.IsClientClickRegistered = true;
            }

            //OnPreRender
            base.OnPreRender(e);
        }

        #region ILocalizeControl メンバ

        void ILocalizeControl.Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
