﻿
namespace Framework.Web.UI.CompositeControls
{
    /// <summary>
    /// GridViewのデータソースのリクエストイベントのイベント引数
    /// </summary>
    public class GridViewSrcRequestEventArgs : System.EventArgs
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public GridViewSrcRequestEventArgs()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public GridViewSrcRequestEventArgs(int startRecord, int maxRecords, string sortExpression)
        {
            this.StartRecord = startRecord;
            this.MaxRecords = maxRecords;
            this.SortExpression = sortExpression;
        }

        /// <summary>
        /// 結果結果データ
        /// </summary>
        public System.Data.DataView DataSource { get; set; }

        /// <summary>
        /// 検索結果の総件数
        /// </summary>
        public int TotalRecords { get; set; }

        /// <summary>
        /// リクエストする, 1から始まるレコード番号。
        /// </summary>
        public int StartRecord { get; set; }

        /// <summary>
        /// リクエストするレコードの最大数。 
        /// </summary>
        public int MaxRecords { get; set; }

        /// <summary>
        /// リクエストするレコードのソート式
        /// </summary>
        public string SortExpression { get; set; }
    }

    /// <summary>
    ///  GridViewのデータソースのリクエストイベント
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public delegate void GridViewSrcRequestEventHandler(object sender, GridViewSrcRequestEventArgs e);
}
