﻿
namespace Framework.Data
{
    /// <summary>
    /// リストソースのリクエストイベントの引数
    /// </summary>
    public class ListSrcRequestEventArgs : System.EventArgs
    {
        /// <summary>
        /// リストキー
        /// </summary>
        public string ListKey;

        /// <summary>
        /// 引数
        /// </summary>
        public string Argument;

        /// <summary>
        /// 応答結果として返すリストソース
        /// </summary>
        public ListSrcDataSet ListSrc;
    }

    /// <summary>
    /// UIなどがリストソースを必要としたときに呼び出すリクエストイベント。
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public delegate void ListSrcRequestEventHandler(object sender, ListSrcRequestEventArgs e);
}
