﻿using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Framework.DB
{
    /// <summary>
    /// DB関連のユーティリティクラスです。
    /// </summary>
    public class DBUtil
    {
        /// <summary>
        /// sql からバインドパラメーターを抽出します。
        /// </summary>
        /// <param name="sql">SQL文</param>
        /// <param name="prefix">接頭語。SQLServerでは"@"</param>
        /// <param name="uniq">trueの場合は、重複を削除する</param>
        /// <returns></returns>
        public static string[] GetBindParams(string sql, char prefix, bool uniq)
        {
            var bindParams = new List<string>();

            var regex = new System.Text.RegularExpressions.Regex(prefix + "[^;), ]+");

            using (var reader = new System.IO.StringReader(sql))
            {
                while (reader.Peek() != -1)
                {
                    string line = reader.ReadLine();
                    if (string.IsNullOrEmpty(line))
                    {
                        continue;
                    }

                    Match match = regex.Match(line);
                    while (match.Success)
                    {
                        string val = match.Value.Substring(1);
                        if (!uniq || !bindParams.Contains(val))
                        {
                            bindParams.Add(val);
                        }

                        match = match.NextMatch();
                    }
                }
            }

            return bindParams.ToArray();
        }
    }
}
