﻿using System;
using System.Security.Principal;

using Framework.Web;
using System.IO;
using Sample1.Master;

namespace Sample1
{
    public class Global : System.Web.HttpApplication
    {

        protected void Application_Start(object sender, EventArgs e)
        {
            Framework.Data.AppSetting.SetListener(new AppSettingListener());
            LTextMgr.SetListener(new LTextSrcListener());
            ListMgr.SetListener(new ListSrcListener());
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {
            //favicon.ico が見つからないときのエラーは無視する。
            var ctx = System.Web.HttpContext.Current;
            if (ctx != null && ctx.Request.Path.EndsWith("favicon.ico"))
            {
                return;
            }

            //ログ出力
            Framework.Log.LoggerPool.GetLogger().Fatal("その他の例外", Server.GetLastError());

#if DEBUG
#else
            //エラー画面へ
            Response.Redirect("Error.htm");
#endif

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }
    }
}