﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;

namespace Framework.Web.UI
{
    /// <summary>
    /// Framework.Web.UI.UIControllerの拡張メソッド群です。
    /// </summary>
    public static class UIControllerExtention
    {
        /// <summary>
        /// Framework.Web.UI.UIControllerのFindControlsを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="pattern"></param>
        /// <returns></returns>
        public static Control[] FindControls(this System.Web.UI.Control target, string pattern)
        {
            return UIController.FindControls(target, pattern);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのFindControlsを実行します。
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="target"></param>
        /// <returns></returns>
        public static T[] FindControls<T>(this System.Web.UI.Control target) where T : class
        {
            return UIController.FindControls<T>(target);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのValidateInputを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="errCtrl"></param>
        /// <returns></returns>
        public static bool ValidateInput(this System.Web.UI.Control target, ref Control errCtrl)
        {
            return UIController.ValidateInput(target, ref errCtrl, false);
        }
        public static bool ValidateInput(this System.Web.UI.Control target, ref Control errCtrl, bool dataTypeOnly)
        {
            return UIController.ValidateInput(target, ref errCtrl, dataTypeOnly);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのSetMappingDataを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="data"></param>
        public static void SetMappingData(this System.Web.UI.Control target, Framework.Data.MappingData data)
        {
            UIController.SetMappingData(target, data);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのGetMappingDataを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public static Framework.Data.MappingData GetMappingData(this System.Web.UI.Control target)
        {
            return UIController.GetMappingData(target);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのLocalizeを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="lang"></param>
        /// <returns></returns>
        public static void Localize(this System.Web.UI.Control target)
        {
            UIController.Localize(target);
        }

        /// <summary>
        /// Framework.Web.UI.UIControllerのClearInputを実行します。
        /// </summary>
        /// <param name="target"></param>
        /// <param name="lang"></param>
        /// <returns></returns>
        public static void ClearInput(this System.Web.UI.Control target)
        {
            UIController.ClearInput(target);
        }
    }
}
