﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// CommandFieldの機能拡張版です。フッター行に追加ボタンが表示されます。
    /// </summary>
    public class LEditField : System.Web.UI.WebControls.CommandField
    {
        /// <summary>
        /// ヘッダテキストのローカライズキー
        /// </summary>
        public string HeaderLTextKey { get; set; }

        /// <summary>
        /// 編集ボタンのローカライズキー
        /// </summary>
        public string EditLTextKey { get; set; }

        /// <summary>
        /// 更新ボタンのローカライズキー
        /// </summary>
        public string UpdateLTextKey { get; set; }

        /// <summary>
        /// キャンセルボタンのローカライズキー
        /// </summary>
        public string CancelLTextKey { get; set; }

        /// <summary>
        /// フッターの追加ボタンのテキスト
        /// </summary>
        public string AddText { get; set; }

        /// <summary>
        /// フッターの追加ボタンのローカライズキー
        /// </summary>
        public string AddLTextKey { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LEditField()
        {
            //デフォルトでEditモードになるようにする
            base.ShowEditButton = true;

            base.EditText = "Edit";
            base.UpdateText = "Update";
            base.CancelText = "Cancel";
            this.AddText = "Add";
        }

        /// <summary>
        /// Initialize
        /// </summary>
        /// <param name="sortingEnabled"></param>
        /// <param name="control"></param>
        /// <returns></returns>
        public override bool Initialize(bool sortingEnabled, System.Web.UI.Control control)
        {
            //ローカライズ
            if (this.HeaderLTextKey.IsNotEmpty())
            {
                this.HeaderText = LTextMgr.GetText(this.HeaderLTextKey);
            }
            if (this.EditLTextKey.IsNotEmpty())
            {
                base.EditText = LTextMgr.GetText(this.EditLTextKey);
            }
            if (this.UpdateLTextKey.IsNotEmpty())
            {
                base.UpdateText = LTextMgr.GetText(this.UpdateLTextKey);
            }
            if (this.CancelLTextKey.IsNotEmpty())
            {
                base.CancelText = LTextMgr.GetText(this.CancelLTextKey);
            }


            return base.Initialize(sortingEnabled, control);
        }

        /// <summary>
        /// InitializeCell
        /// </summary>
        /// <param name="cell"></param>
        /// <param name="cellType"></param>
        /// <param name="rowState"></param>
        /// <param name="rowIndex"></param>
        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
        {
            if (cellType == DataControlCellType.Footer)
            {
                //Footer行の場合は、「Add」ボタンを追加する。
                //CommandName = "Update" なのでクリック時にはRowUpdatingイベントが発生します。
                var btn = (base.ButtonType == ButtonType.Link ? (IButtonControl)new LinkButton() : (IButtonControl)new Button());
                btn.Text = this.AddLTextKey.IsEmpty() ? this.AddText : LTextMgr.GetText(this.AddLTextKey);
                btn.CommandName = "Update";
                btn.CommandArgument = "Footer";

                cell.Controls.Add((Control)btn);
            }
            else
            {
                base.InitializeCell(cell, cellType, rowState, rowIndex);
            }
        }
    }
}
