﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    [DefaultProperty("LTextKey")]
    [ToolboxData("<{0}:LButton runat=server></{0}:LButton>")]
    public class LButton : Button, ILocalizeControl
    {
        /// <summary>
        /// テキストのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        /// <summary>
        /// 確認ダイアログのメッセージのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string ConfirmLTextKey { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LButton()
        {
            //「ENTER」キーによるSubmitを無効にさせるための処理
            base.UseSubmitBehavior = false;
        }

        /// <summary>
        /// OnPreRender
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPreRender(EventArgs e)
        {
            //確認ダイアログを登録
            if (this.ConfirmLTextKey.IsNotBlank())
            {
                JavaScript.RegisterConfirm(this, LTextMgr.GetText(this.ConfirmLTextKey));
            }

            base.OnPreRender(e);
        }

        #region ILocalizeControl メンバ

        void ILocalizeControl.Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
