﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

using Framework;
using Framework.Data;
using Framework.Web.UI.CompositeControls;
using Framework.DB.SqlServerCe;

namespace Sample1.Master
{
    public class ListDb : DbAccessBase
    {
        /// <summary>
        /// tblに全件をFillします。
        /// </summary>
        /// <param name="tbl"></param>
        public void FillData(Framework.Data.ListSrcDataSet ds)
        {
            var sql = @"
                SELECT LIST_KEY as ListKey
                     , VALUE as Value
                     , TEXT as Text
                  FROM TM_LIST
                ";

            base.FillDataTable(ds.ListSrc, sql);
        }
        /// <summary>
        /// データソースリクエスト
        /// </summary>
        /// <param name="e"></param>
        /// <param name="data"></param>
        public void ReqestGridViewSrc(GridViewSrcRequestEventArgs e, MappingData data)
        {
            var select = @"
                |SELECT LIST_KEY
                |     , VALUE
                |     , TEXT
                |     , CONVERT(bigint, ROW_VER) ROW_VER
                ".StripMargin();

            var where = @"
                |  FROM TM_LIST
                | WHERE 1 = 1
                ".StripMargin();

            if (data["PK"].IsNotBlank() == true)
            {
                where += " AND LIST_KEY = @PK";
            }
            if (data["LTEXT_KEY"].IsNotBlank() == true)
            {
                where += " AND LIST_KEY LIKE '%' + @LIST_KEY + '%'";
            }


            //総件数の取得
            string sqlCnt = "SELECT COUNT(*) " + where;
            e.TotalRecords = (int)base.ExecuteScalar(sqlCnt, data);

            //データ取得
            var sql = @"
                |{0}
                |{1}
                |ORDER BY {2}
                |OFFSET {3} ROWS
                |FETCH NEXT {4} ROWS ONLY
                ".StripMargin()
                 .Fmt(select, where, e.SortExpression, e.StartRecord - 1, e.MaxRecords);
            e.DataSource = base.GetDataTable(sql, data).DefaultView;
        }

        /// <summary>
        /// Update
        /// </summary>
        /// <param name="data"></param>
        /// <returns>更新件数</returns>
        public int Update(GridViewPagerUpdateEventArgs e, Framework.Data.MappingData data)
        {
            var sql = @"
                |UPDATE TM_LIST
                |   SET VALUE = @VALUE
                |     , TEXT = @TEXT
                | WHERE LIST_KEY = @LIST_KEY
                |   AND CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                //更新
                cnt = base.ExecuteNonQuery(sql, data);

                if (cnt > 0)
                {
                    //更新後のデータ取得
                    var re = new GridViewSrcRequestEventArgs(1, 1, "LIST_KEY");
                    this.ReqestGridViewSrc(re, new MappingData("PK", data["LIST_KEY"]));
                    e.NewValues = re.DataSource[0];
                }
            });

            return cnt;
        }

        /// <summary>
        /// Insert
        /// </summary>
        /// <param name="data"></param>
        public int Insert(MappingData data)
        {
            var sqlChk = @"
                |SELECT COUNT(*)
                |  FROM TM_LIST
                | WHERE LIST_KEY = @LIST_KEY
                ".StripMargin();

            var sql = @"
                |INSERT INTO TM_LTEXT
                |     ( LIST_KEY
                |     , VALUE )
                |VALUES
                |     ( @LIST_KEY
                |     , @VALUE )
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                if ((int)base.ExecuteScalar(sqlChk, data) == 0)
                {
                    cnt = base.ExecuteNonQuery(sql, data);
                }
            });

            return cnt;
        }


        /// <summary>
        /// Delete
        /// </summary>
        /// <param name="data"></param>
        /// <returns>削除件数</returns>
        public int Delete(MappingData data)
        {
            var sql = @"
                |DELETE FROM TM_LIST
                | WHERE LIST_KEY = @LIST_KEY
                |   AND CONVERT(bigint, ROW_VER) = CONVERT(bigint, @ROW_VER)
                ".StripMargin();

            var cnt = 0;
            base.ExecuteTransaction(() =>
            {
                cnt = base.ExecuteNonQuery(sql, data);
            });

            return cnt;
        }
    }
}