﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="Sample1.Master.List" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title><cc:LLiteral runat="server" LTextKey="Title_ListSrc"></cc:LLiteral></title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div><cc:PageNav runat="server" ID="PageNav"></cc:PageNav></div>
        <asp:Panel runat="server" ID="pnlLang">
            <cc:MDropDownList runat="server" ID="ddlLang" MappingName="Lang"  ListKey="Lang" LocalizeByText="true" 
                OnSelectedIndexChanged="ddlLang_SelectedIndexChanged" AutoPostBack="true"></cc:MDropDownList>
        </asp:Panel>
        <asp:Panel runat="server" ID="pnlSearch">
            <table>
                <tr>
                    <td><cc:LLiteral ID="LLiteral1" runat="server" LTextKey="ListKey"></cc:LLiteral></td>
                    <td><cc:MTextBox ID="MTextBox1" runat="server" MappingName="LIST_KEY"></cc:MTextBox></td>
                </tr>
            </table>
        </asp:Panel>
        <div>
        <cc:LButton runat="server" ID="btnSearch" LTextKey="Search" OnClick="btnSearch_Click" />
        </div>
        <div>
        <cc:GridViewPager runat="server" ID="gvpList" TargetGridView="gvwList" 
            DefaultSortExpression="LIST_KEY ASC"
            OnGridViewSrcRequest="gvpList_GridViewSrcRequest"
            OnRowCommand="gvpList_RowCommand"
            OnRowUpdating="gvpList_RowUpdating"
            OnRowDeleting="gvpList_RowDeleting"/>
        </div>
        <cc:LGridView runat="server" ID="gvwList" AutoGenerateColumns="false"
            DataKeyNames="LIST_KEY"
            ShowFooter="true" PageSize="10" AllowSorting="true" AllowPaging="true">
            <HeaderStyle BackColor="AliceBlue" />
            <FooterStyle BackColor="AliceBlue" />
            <Columns>
                <cc:LTemplateField>
                    <ItemTemplate>
                        <cc:LButton ID="LButton1" runat="server" CommandName="Edit" LTextKey="Edit"/>
                        <cc:LButton ID="LButton2" runat="server" CommandName="Delete" LTextKey="Delete" ConfirmLTextKey="ConfirmDelete" />
                    </ItemTemplate>
                    <EditItemTemplate>
                        <cc:LButton ID="LButton3" runat="server" CommandName="Update" LTextKey="Update" ConfirmLTextKey="ConfirmUpdate" />
                        <cc:LButton ID="LButton4" runat="server" CommandName="Cancel" LTextKey="Cancel" />
                    </EditItemTemplate>
                    <FooterTemplate>
                        <cc:LButton ID="LButton5" runat="server" CommandName="Add" LTextKey="Add" />
                        <cc:LButton ID="LButton6" runat="server" CommandName="Clear" LTextKey="Clear" />
                    </FooterTemplate>
                </cc:LTemplateField>
                <cc:LTemplateField HeaderLTextKey="ListKey" DefaultMappingName="LIST_KEY">
                    <ItemTemplate>
                        <cc:MLabel runat="server"></cc:MLabel>
                    </ItemTemplate>
                    <FooterTemplate>
                        <cc:MTextBox runat="server" MaxLength="100"></cc:MTextBox>
                    </FooterTemplate>
                </cc:LTemplateField>
                <cc:LTemplateField HeaderLTextKey="ListValue" DefaultMappingName="VALUE">
                    <ItemTemplate>
                        <cc:MLabel runat="server"></cc:MLabel>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <cc:MTextBox ID="MTextBox3" runat="server" MaxLength="100"></cc:MTextBox>
                    </EditItemTemplate>
                    <FooterTemplate>
                        <cc:MTextBox runat="server" MaxLength="100"></cc:MTextBox>
                    </FooterTemplate>
                </cc:LTemplateField>
                <cc:LTemplateField HeaderLTextKey="ListText" DefaultMappingName="TEXT">
                    <ItemTemplate>
                        <cc:MLabel runat="server"></cc:MLabel>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <cc:MTextBox runat="server" MaxLength="100"></cc:MTextBox>
                    </EditItemTemplate>
                    <FooterTemplate>
                        <cc:MTextBox runat="server" MaxLength="100"></cc:MTextBox>
                    </FooterTemplate>
                </cc:LTemplateField>
                <cc:LTemplateField HeaderLTextKey="RowVer" DefaultMappingName="ROW_VER">
                    <ItemTemplate>
                        <cc:MLabel ID="MLabel3" runat="server"></cc:MLabel>
                    </ItemTemplate>
                </cc:LTemplateField>
            </Columns>
        </cc:LGridView>
        <cc:LLabel runat="server" ID="lblMsg" EnableViewState="false" style="color:Red; font-weight: bold"></cc:LLabel>
    </div>
    </form>
</body>
</html>
