﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Framework.Data;

namespace Framework.Web
{
    /// <summary>
    /// ViewStateの管理
    /// </summary>
    public class ViewStateMgr
    {
        /// <summary>
        /// マッピングデータをビューステートに保存します
        /// </summary>
        /// <param name="viewState"></param>
        /// <param name="key"></param>
        /// <param name="data"></param>
        public static void SaveMappingData(System.Web.UI.StateBag viewState, string key, MappingData data)
        {
            viewState[key] = data.GetBaseData();
        }

        /// <summary>
        /// ビューステートからマッピングデータをロードします
        /// </summary>
        /// <param name="viewState"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static MappingData LoadMappingData(System.Web.UI.StateBag viewState, string key)
        {
            return new MappingData((System.Collections.Specialized.NameValueCollection)viewState[key]);
        }
    }
}
