﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:MLabel runat=server></{0}:MLabel>")]
    public class MLabel : Label, IMappingControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string MappingName { get; set; }


        #region IMappingControl メンバ

        public void RequestMappingData(Framework.Data.MappingData data)
        {
            data.Add(this.MappingName, base.Text);
        }

        public void SetMappingData(Framework.Data.MappingData data)
        {
            if (!string.IsNullOrEmpty(this.MappingName))
            {
                string val = data[this.MappingName];
                if (val != null)
                {
                    base.Text = val;
                }
            }
        }

        #endregion
    }
}
