﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// ローカライズ機能を持ったリンクボタン
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:LLinkButton runat=server></{0}:LLinkButton>")]
    public class LLinkButton : LinkButton, ILocalizeControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
