﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI.CompositeControls
{
    /// <summary>
    /// パネルを折りたたみ可能にするエクステンダー
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:CollapsiblePanelExtender runat=server></{0}:CollapsiblePanelExtender>")]
    public class CollapsiblePanelExtender : CompositeControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string CollapseControlID { get; set; }

        [Category("Custom")]
        [DefaultValue("")]
        public string ImageControlID { get; set; }
        
        [Category("Custom")]
        [DefaultValue("")]
        public string CollapsedImage { get; set; }

        [Category("Custom")]
        [DefaultValue("")]
        public string ExpandedImage { get; set; }

        /// <summary>
        /// 折りたたみ状態を取得または設定します
        /// </summary>
        [Category("Custom")]
        [DefaultValue("false")]
        public bool Collapsed
        {
            get 
            {
                EnsureChildControls();
                return bool.Parse(this.hid_Collapsed.Value);
            }
            set 
            {
                EnsureChildControls();
                hid_Collapsed.Value = value.ToString().ToLower();
            }
        }

        private System.Web.UI.HtmlControls.HtmlInputHidden hid_Collapsed;
        private System.Web.UI.WebControls.Image _img;


        protected override void CreateChildControls()
        {
            hid_Collapsed = new System.Web.UI.HtmlControls.HtmlInputHidden();
            hid_Collapsed.ID = "hid_Collapsed";
            hid_Collapsed.Value = false.ToString().ToLower();
            this.Controls.Add(hid_Collapsed);

            base.CreateChildControls();
        }

        protected override void OnInit(EventArgs e)
        {
            EnsureChildControls();

            _img = this.Parent.FindControl(this.ImageControlID) as Image;
            if (_img == null)
            {
                throw new Exception(string.Format("ImageControlID({0})が見つかりません。", this.ImageControlID));
            }

            base.OnInit(e);
        }

        protected override void OnPreRender(EventArgs e)
        {
            if (!Page.ClientScript.IsClientScriptBlockRegistered("CollapsePanel"))
            {
                string func = @"
                    |function CollapsePanel(hidID, imgID, pnlID) {
                    |   var hid = document.getElementById(hidID);
                    |   var img = document.getElementById(imgID);
                    |   var pnl = document.getElementById(pnlID);
                    |   if (hid.value.toLowerCase() == 'true') {
                    |        img.src = '{ExpandedImage}';
                    |        if (pnl) pnl.style.display = 'block';
                    |        hid.value = 'false';
                    |    } else {
                    |        img.src = '{CollapsedImage}';
                    |        if (pnl) pnl.style.display = 'none';
                    |        hid.value = 'true';
                    |    }
                    |}
                    ".StripMargin();
                func = func.Replace("{CollapsedImage}", System.Web.VirtualPathUtility.ToAbsolute(this.CollapsedImage));
                func = func.Replace("{ExpandedImage}", System.Web.VirtualPathUtility.ToAbsolute(this.ExpandedImage));

                Page.ClientScript.RegisterClientScriptBlock(Page.GetType(), "CollapsePanel", func, true);
            }

            //imgのクリックイベントに登録
            string script = string.Format("CollapsePanel('{0}','{1}', '{2}');", this.hid_Collapsed.ClientID, this.ImageControlID, this.CollapseControlID);
            _img.Attributes["onclick"] = script;

            //スタートアップスクリプトに前回状態を復元するスクリプトを登録
            this.Collapsed = !this.Collapsed;
            Page.ClientScript.RegisterStartupScript(Page.GetType(), this.ID, script, true);


            base.OnPreRender(e);
        }

    }
}
