﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using log4net;
using System.Diagnostics;

namespace Framework.Log
{
    internal sealed class Logger : ILogger
    {
        internal readonly ILog logger;

        internal Logger(ILog logger)
        {
            this.logger = logger;
        }

        public void XXX_Debug(object message, Exception e)
        {
            logger.Debug(message, e);
        }

        public void XXX_Debug(object message)
        {
            logger.Debug(this.AppendMethodName(message));
        }

        public void XXX_DebugFormat(string format, params object[] args)
        {
            logger.Debug(this.AppendMethodName(string.Format(format, args)));
        }

        public void Error(object message, Exception e)
        {
            logger.Error(message, e);
        }

        public void Error(object message)
        {
            logger.Error(this.AppendMethodName(message));
        }

        public void ErrorFormat(string format, params object[] args)
        {
            logger.Error(this.AppendMethodName(string.Format(format, args)));
        }

        public void Fatal(object message, Exception e)
        {
            logger.Fatal(message, e);
        }

        public void Fatal(object message)
        {
            logger.Fatal(message);
        }

        public void FatalFormat(string format, params object[] args)
        {
            logger.FatalFormat(format, args);
        }

        public void Info(object message, Exception e)
        {
            logger.Info(message, e);
        }

        public void Info(object message)
        {
            logger.Info(message);
        }

        public void InfoFormat(string format, params object[] args)
        {
            logger.InfoFormat(format, args);
        }

        public void Warn(object message, Exception e)
        {
            logger.Warn(message, e);
        }

        public void Warn(object message)
        {
            logger.Warn(this.AppendMethodName(message));
        }

        public void WarnFormat(string format, params object[] args)
        {
            logger.Warn(this.AppendMethodName(string.Format(format, args)));
        }

        public bool IsDebugEnabled
        {
            get { return logger.IsDebugEnabled; }
        }

        public bool IsErrorEnabled
        {
            get { return logger.IsErrorEnabled; }
        }

        public bool IsFatalEnabled
        {
            get { return logger.IsFatalEnabled; }
        }

        public bool IsInfoEnabled
        {
            get { return logger.IsInfoEnabled; }
        }

        public bool IsWarnEnabled
        {
            get { return logger.IsWarnEnabled; }
        }

        /// <summary>
        /// メッセージにメソッド名を付加したものを返します。
        /// </summary>
        /// <param name="msg"></param>
        /// <returns></returns>
        public string AppendMethodName(object msg)
        {
            //スタックトレースからログ出力をしたメソッド部分を取得
            var method = string.Empty;
            using (var sr = new System.IO.StringReader(Environment.StackTrace))
            {
                //いらない部分は読み飛ばし
                sr.ReadLine(); sr.ReadLine(); sr.ReadLine(); sr.ReadLine();

                //Framework内のスタックトレースは無視する。
                do
                {
                    method = sr.ReadLine().Trim().SubstrAfter(" ");

                } while (sr.Peek() != -1 && method.StartsWith("Framework"));
            }

           return string.Format("{0}{1}[{2}]", msg, Environment.NewLine, method);
        }
    }
}
