<?php
require_once( 'PEAR.php' );
require_once( DIR_LIB.'SdAccessLevel.class.php');

// 
define( 'SESSIONNAME_AUTH_USER',		'/auth/user' );
define( 'AUTO_LOGIN_INTERVAL',			(int) ( 60 * 60 * 24 * 30 ));

/**
 * SdAuth.class.php
 * $_SESSION ѤƤΤǡ session_start ƤӽФƤ뤳Ȥ
 *
 * @version $Id: SdAuth.class.php,v 1.5 2005/11/04 21:03:24 junneko Exp $
 **/

class SdAuth {

	/**
	 * 󥹥ȥ饯
	 * 
	 */
	function SdAuth(){
		
		$this->_config = null;
		$this->_ddo    = null;
		$this->_accessLevel = null;
		
	}
		
	/**
	 * 󤹤
	 *
	 * @param  MemberDAO  $user    
	 * @param  String  account    
	 * @param  String  password   ѥ
	 * @return boolean β
	 * 
	 */
	function login( $email, $password ){

		// user
		$userddo = DB_DataObject::factory(TABLE_PREFIX.'user');
		$userddo->email    = $email;
		$userddo->password = $password;
		$userddo->find();
		if( ! $userddo->fetch() ){return false; }
		$data = $userddo->toArray();
		$userddo->free();
		// åID
		session_regenerate_id();
		
		return $this->refresh( $data['id'] );

	}

	/**
	 * ư󤹤
	 *
	 * @param  SdUserDAO  $userdao
	 * @param  String     $lcode
	 * @return boolean β
	 * 
	 */
	function autoLogin(){
	
		list( $userId, $lcode ) = split('_', $_COOKIE['lcode'] );

		if( $userId == '' || $lcode=='' ){ return false; }
		
		$lcode_crypt = crypt( $lcode, substr( $lcode,0,2 ));

		// user
		$userddo = DB_DataObject::factory(TABLE_PREFIX.'user');
		$userddo->id = $userId;
		$userddo->find();
		if( ! $userddo->fetch() ){
			return false;
		}
		$data = $userddo->toArray();

		$userddo->free();
//		$data = $userdao->getOne( $userId );
		
		if( $data['lcode'] != $lcode_crypt ){
			$data = array();
		}
		
		if( sizeof( $data ) == 0 ){
			return false;
		}
	
		session_regenerate_id();
		
		return $this->refresh( $data['id'] );
	}

	/**
	 * Ȥ
	 *
	 * @return boolean
	 * 
	 */
	function logout(){
		
		unset( $_SESSION[ SESSIONNAME_AUTH_USER ] );
		unset( $this->_config );
		return true;
	}
	
	
	/**
	 * 桼
	 *
	 * @param MemberDAO $user
	 * @param int $id	
	 * @return true;
	 **/
	function refresh( $id ){
//echo "refresh<br>";
		$userddo = DB_DataObject::factory(TABLE_PREFIX.'user');
		$userddo->id = $id;
		$userddo->find();
		if( ! $userddo->fetch() ){
			return false;
		}
		$data = $userddo->toArray();
		$userddo->free();

//		if( PEAR::isError( $arr )){
//			return false;
//		}
//		if( sizeof( $arr ) == 0 ){
//			return false;
//		}
			
		unset( $data['password'] );	// ѥɤϺ
		$_SESSION[ SESSIONNAME_AUTH_USER ] = $data;
		
		$this->attach();
		
		return true;
	}
	
	/**
	 * å󤫤
	 *
	 * @return boolean ߼Իfalse ֤
	 * 
	 */
	function attach(){
		
		$this->_config = $_SESSION[ SESSIONNAME_AUTH_USER ];
		
		$this->_accessLevel = new SdAccessLevel($this->_config['access_level']);
		
		return $this->isLogin();
		
	}
	
	
	function getConfig(){
		return $this->_config;
	}
	
	function isLogin(){

		if( ! is_array( $this->_config ) ){
			return false;
		}

		if( ! ( $this->_config['id'] > 0 ) ){
			return false;
		}
		
		return true;
	}
	
	/**
	 * 桼ID
	 *
	 * @return int
	 */
	function getId(){
		if( ! is_array( $this->_config )){
			return PEAR::raiseError( 'AuthMember.getId error.' );
		}
		
		return $this->_config['id'];
	}

	function changeAutoLoginMode(  $flg=true ){

		if( ! $this->isLogin() ){
			return false;
		}
		
		$lcode = $lcode_crypt = '';
		
		if( $flg == true ){
			srand((double) microtime() * 1000000);
// DEBUG 2005/05/11 by J.YOSHIMURA
//			$lcode = md5(uniqid(rand(),1));
			$lcode = md5('testdayo-'.$this->getId());
			$lcode_crypt = crypt( $lcode, substr( $lcode,0,2 ));
		}
//		$userdao->setLcode( $this->getId(), $lcode_crypt );

		$userddo = DB_DataObject::factory(TABLE_PREFIX.'user');
		$userddo->id = $this->getId();
		$userddo->lcode = $lcode_crypt;
		$userddo->update();
		$userddo->free();
		
		if( $flg == true ){
			setcookie ("lcode", $this->getId().'_'.$lcode, time() + AUTO_LOGIN_INTERVAL, '/' );
		} else {
			setcookie ("lcode", '', time() - 1000, '/' );
		}
		
		return true;
	
	}

	function crypt( $word ){
		return crypt( $lcode, substr( $word,0,2 ));
	}
	
	function getAccessLevel(){
		return $this->_accessLevel;
	}
}

?>