var Sd = {
  Version: '0.21'
};

Sd.Resizable = Class.create();
Sd.Resizable.prototype = {
	initialize: function(element){
		var options = Object.extend({
  			bounds: false,
		    region: 4,
  			mixW: 40, 
  			minH: 40
		}, arguments[1] || {});

		this.element      = $(element);
		this.bounds       = options.bounds;
		this.region       = options.region;
		this.minW         = options.minW;
		this.minH         = options.minH;
//		this.active       = false;
		this.resizeW=this.resizeN=this.resizeE=this.resizeS=false;
		
		this.resizewindow = document.createElement('div');
		this.resizewindow.id=this.element.id+'_resizewindow';
	    var props= {
	    	border:'1px solid blue',background:'transparent', overflow:'hidden', position:'absolute',
			visibility:'hidden'
		};
		for( i in props ){
			this.resizewindow.style[i]=props[i];
		}
		this.element.parentNode.appendChild(this.resizewindow);
	
		Event.observe(this.element, "mousedown", this.startResize.bindAsEventListener(this));
		Event.observe(document, "mouseup",      this.endResize.bindAsEventListener(this));
		Event.observe(document, "mousemove",    this.updateResize.bindAsEventListener(this));
	},
	currentLeft: function() {
		return parseInt(this.element.style.left || '0');
	},
	currentTop: function() {
		return parseInt(this.element.style.top || '0');
	},
	startResize: function(event){
	
		if(!Event.isLeftClick(event)) { return ; }
	
		var cursor=this.element.style.cursor;
		this.resizeW=this.resizeN=this.resizeE=this.resizeS=false;
		switch(cursor){
		case 'nw-resize':
			this.resizeW=this.resizeN=true; break;
		case 'sw-resize':
			this.resizeW=this.resizeS=true; break;
		case 'ne-resize':
			this.resizeE=this.resizeN=true; break;
		case 'se-resize':
			this.resizeE=this.resizeS=true; break;
		case 'w-resize':
			this.resizeW=true; break;
		case 'n-resize':
			this.resizeN=true; break;
		case 'e-resize':
			this.resizeE=true; break;
		case 's-resize':
			this.resizeS=true; break;
		default:
			return;
		}

		Position.clone(this.element.id,this.resizewindow.id);
		this.resizewindow.style.zIndex= '10';
		this.element.style.zIndex= '1';
		this.resizewindow.style.visibility='visible';
		this.originalX=(event.clientX+document.body.scrollLeft);
		this.originalY=(event.clientY+document.body.scrollTop);
		this.originalW=this.resizewindow.clientWidth;
		this.originalH=this.resizewindow.clientHeight;

        Event.stop(event);   	
	},
	endResize: function(event){
        if(this.resizeW || this.resizeN || this.resizeE || this.resizeS){
        	this.resizewindow.style.visibility='hidden';
        	if( this.bounds ){
        		this.bounds(parseInt(this.resizewindow.style.left || 0 ), parseInt(this.resizewindow.style.top || 0 ),this.resizewindow.clientWidth,this.resizewindow.clientHeight);
        	} else {
        		Position.clone(this.element.id,this.resizewindow.id);        
        	}
			this.resizeW=this.resizeN=this.resizeE=this.resizeS=false;
			document.body.style.cursor='auto';
        	Event.stop(event);   	
        }		
	},
	updateResize:function(event){
        if(this.resizeW || this.resizeN || this.resizeE || this.resizeS){
			this.draw(event);
			Event.stop(event);
   			return;
		} 
		var x= (( event.clientX + document.body.scrollLeft ) - this.currentLeft());
		var y= (( event.clientY + document.body.scrollTop ) - this.currentTop());
		var cursor;
		if(( x < this.region ) && ( y < this.region )){
			cursor='nw-resize';
		} else if(( x < this.region ) && ( y > ( this.element.clientHeight - this.region ))){
			cursor='sw-resize';
		} else if(( x > ( this.element.clientWidth - this.region )) && ( y < this.region )){
			cursor='ne-resize';
		} else if(( x > ( this.element.clientWidth - this.region )) && ( y > ( this.element.clientHeight - this.region ))){
			cursor='se-resize';
		} else if( x < this.region ){
			cursor='w-resize';
		} else if( y < this.region ){
			cursor='n-resize';
		} else if( x > ( this.element.clientWidth - this.region )){
			cursor='e-resize';
		} else if( y > ( this.element.clientHeight - this.region )){
			cursor='s-resize';
		} else {
			cursor='auto';
		}
		if( cursor!='auto'){
			Event.stop(event);
		}
		this.element.style.cursor=cursor;
	},
	draw:function(event){
		var w;
		var h;
		var clientX = event.clientX + document.body.scrollLeft;
		var clientY = event.clientY + document.body.scrollTop;
		if(this.resizeW){
			w = this.originalW+(this.originalX-clientX);
			if(w>this.minW){
				this.resizewindow.style.left= (this.currentLeft() - (this.originalX-clientX)) + 'px';
				this.resizewindow.style.width  = w + 'px';		  		
			}
		}
		if(this.resizeN){
			h = this.originalH+(this.originalY-clientY);
			if(h>this.minH){
				this.resizewindow.style.top= (this.currentTop()-(this.originalY-clientY)) + 'px';
				this.resizewindow.style.height  = h + 'px';		  		
			}
		}
		if(this.resizeE){
			w = this.originalW+(clientX-this.originalX);
			if( w > this.minW )
				this.resizewindow.style.width  = w + 'px';		  		
		}
		if(this.resizeS){
			h = this.originalH+(clientY-this.originalY);
			if( h > this.minH)
				this.resizewindow.style.height = h + 'px';		  		
		}
	}
};

Sd.Window= Class.create();
Sd.Window.prototype = {
   
	initialize: function(id){
		
		if(!document.body) return null;

		var options = Object.extend({
  			titleColor:  '#0000ff',
  			canvasColor: '#00ccff'
		},arguments[1] || {});
		
		this.id=id;
		this.titleColor  = options.titleColor;
		this.canvasColor = options.canvasColor;
		
		var props={};
        props={
        	visibility:'hidden',border:'thin solid black',background:'white',
        	overflow:'hidden',position:'absolute'
        };
		this.window=this.createElement('window',props);
		document.body.appendChild(this.window);

		props={ border:'0px solid blue',background:this.titleColor,overflow:'hidden',position:'relative',
		        top:'0px',left:'0px',width:'100%',height:'20px',cursor:'move'
		};
		this.titlebar=this.createElement('titlebar',props);
		this.window.appendChild(this.titlebar);
		
		props = {
			border:'0px solid black',overflow:'hidden',	background: this.canvasColor,
			top:'0px',left:'0px',width:'100%',height:'0px',padding:'2px'
		};
		this.canvas=this.createElement('canvas',props);
		this.window.appendChild(this.canvas);
		
		this.draggable=new Draggable( this.window, {
			starteffect: function(element) {},endeffect: function(element){},handle:this.titlebar
		});
		
		this.resizable= new Sd.Resizable( this.window.id, {
			observer:this, 
			minW:40,
			minH:40,
			bounds:this.setBounds.bind(this) });
		
		return this;
   },
   onChangeSize: function(l,t,w,h){
// 		this.setSize(w,h);
		this.setBounds(l,t,w,h);
   },
   createElement: function(name,options){
   		
   		var element=document.createElement('div');
   		element.id= this.id+'_'+name;
   		
   		if( options ){
			for( i in options ){
				if(options.hasOwnProperty(i)){
					element.style[i]=options[i];
				}
			}
   		}
   		
 		return element;   		
   },
   setBounds: function(x,y,w,h){
   		this.setLocation(x,y);
		this.setSize(w,h);
   },
   setLocation: function(x,y){
   		this.window.style.top = y+'px';
		this.window.style.left= x+'px';
   },
   setSize: function(w,h){
   		this.window.style.width = w+'px';
		this.window.style.height= h+'px';
		this.canvas.style.height=(h-20)+'px';
	},
	show: function(){
   		this.window.style.visibility='visible';
   },
   getId: function(){
   		return this.id;
   },
    hide: function(){
   		this.window.style.visibility='hidden';
   },
   setInnerHTML: function(html){
   		this.canvas.innerHTML=html;
   },
   setTitle: function(title){
   		this.titlebar.innerHTML=title;
   }
};

////////////////////////////////////////////////////////////////////////////////

Sd.Line=Class.create();
Sd.Line.prototype={
	initialize: function(posA,posB){
		this.line=[ this.addLine(),this.addLine(),this.addLine()];
		this.draw(posA,posB);
	},
	draw: function(posA,posB){
		if( posA.x < posB.x ){
			posA1=posA;posB1=posB;
		} else {
			posA1=posB;posB1=posA;
		}
		var xx=(posB1.x-posA1.x) / 2;
		this.drawLine(this.line[0],posA1.x,posA1.y,xx,2);
		this.drawLine(this.line[1],posA1.x+xx,posA1.y,2,(posB1.y-posA1.y));
		this.drawLine(this.line[2],posA1.x+xx,posB1.y,xx,2);
	},
	createLine: function(l,t,w,h){
		var element=document.createElement('div');
		var style=element.style;
		style.border='';
		style.background='black';
		style.position='absolute';
		style.left=l+'px';
		style.top=t+'px';
		style.width=w+'px';
		style.height=h+'px';
		document.body.appendChild(element);
		return ;
	},
	addLine: function(){
		var element=document.createElement('div');
		element.id='line'+Math.random();
		element.style.visibility='hidden';
		element.style.position='absolute';
		document.body.appendChild(element);
		return element;
	},
	drawLine: function( line,l,t,w,h ){
//alert(line);	
		var style=line.style;
//		style.visibility='hidden';
		style.background='black';
//		style.position='absolute';
		style.left=l+'px';
		style.top=t+'px';
		style.width=w+'px';
		style.height=h+'px';
		style.visibility='visible';
//for(i in style){ alert( i + ';' + style[i]); }
	}

};

////////////////////////////////////////////////////////////////////////////////

Sd.SwitchVisible=Class.create();
Sd.SwitchVisible.prototype={
	initialize: function(switchId,targetId){
	
		this.switchElement = $(switchId);
		this.targetElement = $(targetId);
		
		this.targetElement.style.visibility='hidden';
		this.targetElement.style.height='0';
		this.switchElement.innerHTML='OPEN';
		
		Event.observe(this.switchElement, "click", this.onclick.bindAsEventListener(this));
		
	},
	onclick: function(e){
		text = this.switchElement.innerHTML;
		if(text=='OPEN'){
			this.targetElement.style.visibility='visible';
			this.targetElement.style.height='100%';
			this.switchElement.innerHTML='CLOSE';
			Event.stop(e);
		}
		if(text=='CLOSE'){
			this.targetElement.style.visibility='hidden';
			this.targetElement.style.height='0';
			this.switchElement.innerHTML='OPEN';
      		Event.stop(e);
		}
	}
	
};