<?php
/********************************************************************************
 * $Id: edit_career.php,v 1.6 2005/11/04 21:02:34 junneko Exp $
 ********************************************************************************/
/********************************************************************************
 *
 * 
 *
 ********************************************************************************/

require_once( './global_config.php' );
// require_once( DIR_LIB.'SdDB.class.php');
require_once( DIR_LIB.'SdSmarty.class.php');
require_once( DIR_LIB.'SdSession.class.php');
require_once( DIR_LIB.'SdRequest.class.php');
require_once( DIR_LIB.'SdAuth.class.php');
require_once( DIR_LIB.'SdAccessLevel.class.php');

require_once( 'function.inc.php' );

// HTML/QuickForm
require_once 'HTML/QuickForm/Controller.php';
require_once 'HTML/QuickForm/Action/Submit.php';
require_once 'HTML/QuickForm/Action/Display.php';
require_once 'HTML/QuickForm/Renderer/ArraySmarty.php';

/********************************************************************************
 *
 * SdRequest
 *
 ********************************************************************************/

$request = new SdRequest();
$req = $request->getParams();

/*******************************************************************************
 *
 * å󳫻
 *
 ******************************************************************************/

$objSession = new SdSession();
$objSession->start();
$ses =  & $objSession->getSession('/diary');

/********************************************************************************
 *
 * 󥪥֥Ⱥ
 *
 ********************************************************************************/

$auth = new SdAuth();

if( ! $auth->attach() ){
	header('Location: '.URL_BASE );
	exit();
}
$accessLevel = $auth->getAccessLevel();
if( ! $accessLevel->isEditable()){
	header('Location: '.URL_BASE.'home.php' );
	exit();
}

$userId = $auth->getId();

if( isset( $_GET['id'] )){
	$id     = $_GET['id'];
}

/********************************************************************************
 *
 * QucikForm
 *
 ********************************************************************************/

$form = new HTML_QuickForm('frm', 'post');
$form->addElement('header',   'first', 'ꥢ' );
$form->addElement('hidden',   'detectChar', 'detectChar' );
$form->addElement('hidden',   'id', '' );
$form->addElement('select',   'project_id',    'ץ', getProjectArray());
$form->addElement('select',   'user_id',       '桼',       getUserArray());
$form->addElement('date',     'start_date',    'ǯ',   array('format'=>'Ymd','minYear'=>1980) );
$form->addElement('date',     'end_date',      'λǯ',   array('format'=>'Ymd','minYear'=>1980) );
//$form->addElement('text',     'industry',    'ȼ',         array( 'size'=>50 ) );
$form->addElement('text',     'category',      '',         array( 'size'=>50 ) );
$form->addElement('text',     'title',         '̾',         array( 'size'=>50 ) );
$form->addElement('text',     'role',          '',         array( 'size'=>50 ) );
$form->addElement('text',     'tech',          '׷',     array( 'size'=>50 ) );
$form->addElement('textarea', 'description',   '' ,        array( 'cols'=>80,'rows'=>3));
$form->addElement('submit',   'submit','');
$form->addElement('reset',    'reset','Reset');

// Validate the radio buttons
$form->addRule('user_id',      '桼ϤƤ',     'required','');
$form->addRule('start_date',   'ǯϤƤ', 'required','');
$form->addRule('end_date',     'λǯϤƤ', 'required','');
$form->addRule('industry',     'ȼϤƤ',       'required','');
$form->addRule('category',     '̤ϤƤ',       'required','');
$form->addRule('title',        '̾ϤƤ',       'required','');
$form->addRule('role',         'ϤƤ',       'required','');
$form->addRule('tech',         'ѤϤƤ',       'required','');

$form->setConstants( array( 'detectChar'=>'' ));
$form->applyFilter( '__ALL__', 'convertEncoding' );

if( isset($id) ){

	// career
	$careerddo = DB_DataObject::factory(TABLE_PREFIX.'career');
	$careerddo->id = $id;
	$careerddo->find();
	if( $careerddo->fetch() ){
		$item = $careerddo->toArray();
		$item['techtagwords'] = trim( $item['techtagwords'] );
		$item['roletagwords'] = trim( $item['roletagwords'] );
		$form->setDefaults( $item );
	}
	$careerddo->free();
}

$template = 'edit_career.html';

if( $form->validate() ){

	// OK	
	$arr = $form->exportValues();
	
	// TODO: ʬڤΥ٤
	// career
	$item = DB_DataObject::factory(TABLE_PREFIX.'career');
	$item->user_id        		= $arr['user_id'];
	$item->project_id           = $arr['project_id'];
	$item->start_date			= $arr['start_date']['Y'].'-'.$arr['start_date']['m'].'-'.$arr['start_date']['d'];
	$item->end_date				= $arr['end_date']['Y'].'-'.$arr['end_date']['m'].'-'.$arr['end_date']['d'];
	$item->industry				= $arr['industry'];
	$item->category				= $arr['category'];
	$item->title				= $arr['title'];
	$arr['role']                = str_replace( '', ' ', $arr['role'] );
	$arr['role']                = str_replace( '', ' ', $arr['role'] );
	$arr['tech']                = str_replace( '', ' ', $arr['tech'] );
	$arr['tech']                = str_replace( '', ' ', $arr['tech'] );
	$item->role                 = $arr['role'];
	$item->tech                 = $arr['tech'];
	$item->description		= $arr['description'];
	$item->working_weeks = getWorkingWeeks( $item->start_date, $item->end_date );

	if( $arr['id'] != '' ){
		$item->id = $arr['id'];
		$item->update();
		$id = $arr['id'];
	} else {
		$id = $item->insert();
	}
	
	// tagddo
	$tagddo = DB_DataObject::factory(TABLE_PREFIX.'tag');
	$tagddo->whereAdd( "owner_id = $id" );
	$tagddo->delete(true);
	$tagddo->free();
	
	$regs = array();

	// category
	preg_match_all('/\[([^]]+)\]/', $arr['category'], $regs);
	foreach( $regs[1] as $word ){
		$tagddo = DB_DataObject::factory(TABLE_PREFIX.'tag');
		$tagddo->owner_name = TABLE_PREFIX.'career.category';
		$tagddo->owner_id = $id;
		$tagddo->word       = $word;
		$tagddo->insert();
		$tagddo->free();
	}
	
	// techtagwords
	preg_match_all('/\[([^]]+)\]/', $arr['tech'], $regs);
	foreach( $regs[1] as $word ){
		$tagddo = DB_DataObject::factory(TABLE_PREFIX.'tag');
		$tagddo->owner_name = TABLE_PREFIX.'career.tech';
		$tagddo->owner_id = $id;
		$tagddo->word       = $word;
		$tagddo->insert();
		$tagddo->free();
	}

	// roletagwords
	preg_match_all('/\[([^]]+)\]/', $arr['role'], $regs);
	foreach( $regs[1] as $word ){
		$tagddo = DB_DataObject::factory(TABLE_PREFIX.'tag');
		$tagddo->owner_name = TABLE_PREFIX.'career.role';
		$tagddo->owner_id = $id;
		$tagddo->word       = $word;
		$tagddo->insert();
		$tagddo->free();
	}
	
	$form->freeze();

	$template = 'edit_career_execute.html';
}

/*******************************************************************************
 *
 * ǡ
 *
 ******************************************************************************/

/*******************************************************************************
 *
 * 
 *
 ******************************************************************************/

$smarty = new SdSmarty();

assignTagTables($smarty);

$renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty,true);
$renderer->setErrorTemplate( '<font class="error">{$error}</font>' );
$renderer->setRequiredTemplate('{if $required}<span style="color: red;">*</span>{/if}{$html}');
$form->accept($renderer);
$smarty->assign( 'form', $renderer->toArray() );

$smarty->display( DIR_TEMPLATE.$template );

/*******************************************************************************
 *
 * λ
 *
 ******************************************************************************/

exit();

/*******************************************************************************
 *
 * ؿ
 *
 ******************************************************************************/
 
function getWorkingWeeks( $startDate, $endDate ){

	list($y,$m,$d) = split('-',$startDate);
	$startDays = mktime( 0,0,0,$m,$d,$y);
	list($y,$m,$d) = split('-',$endDate);
	$endDays = mktime( 0,0,0,$m,$d,$y);
	
//	if( $startDays == $endDays ) return 1;
	
	return ceil( ( $endDays - $startDays + 1 ) / ( 60 * 60 * 24  * 7 ));
}

function getProjectArray(){
	
	// project
	$ddo = DB_DataObject::factory(TABLE_PREFIX.'project');
	$ddo->orderBy('id');
	$ddo->find();
	$tbl = array();
	$tbl['0'] = '----------------';
	while ($ddo->fetch()) {
//		$arr = $ddo->toArray();
	    $tbl[$ddo->id] = $ddo->id;
	}
	$ddo->free();

	return $tbl;
}

function getUserArray(){
	
	// project
	$ddo = DB_DataObject::factory(TABLE_PREFIX.'user');
	$ddo->orderBy('id');
	$ddo->find();
	$tbl = array();
	while ($ddo->fetch()) {
//		$arr = $ddo->toArray();
	    $tbl[$ddo->id] = $ddo->nickname;
	}
	$ddo->free();

	return $tbl;
}

?>