#!/bin/bash -f
#
# サービスの状態変更
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
CHKCONFIG=/sbin/chkconfig

###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 8 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [Service] [0] [1] [2] [3] [4] [5] [6]
  echo
  echo "[Service]     ... サービス名"
  echo "[0]           ... Run Level 0"
  echo "[1]           ... Run Level 1"
  echo "[2]           ... Run Level 2"
  echo "[3]           ... Run Level 3"
  echo "[4]           ... Run Level 4"
  echo "[5]           ... Run Level 5"
  echo "[6]           ... Run Level 6"
  echo "                  on, off, - の3種類を設定可能"
  echo "                  - は設定を変更しない"
  exit $USAGE
fi

SERVICE=$1

# サービスの存在確認

echo
echo \#\#\# $SERVICE サービスを確認します。
echo
echo \# $CHKCONFIG --list $SERVICE

SERVICE_LEVEL=`$CHKCONFIG --list $SERVICE`
RESULT=$?
echo $SERVICE_LEVEL

if [ $RESULT -ne 0 ]; then
  echo
  echo \#\#\# サービスが登録されていません。
  echo \#\#\# 終了します。
  echo
  exit $PASSED
fi

# ループ用変数
declare -i NUM=1
declare -i LEVEL=0
MESSAGE_OUT="false"

# 設定情報の表示
SERVICE_CONFIG=""
while [ $LEVEL -le 6 ];
do
  NUM=$LEVEL+2
  eval MODE='$'$NUM
  SERVICE_CONFIG=${SERVICE_CONFIG}" "${LEVEL}":"${MODE}
  LEVEL=$LEVEL+1
done

echo
echo \#\#\# サービスを下記のとおり設定します。
echo \#\#\# サービス : $SERVICE
echo \#\#\# 設定 : $SERVICE_CONFIG
echo

# ループ用変数の再初期化
NUM=1
LEVEL=0

# コンフィグの変更を行う(値が変わるもののみ実行)
while [ $LEVEL -le 6 ];
do

  NUM=$LEVEL+2
  eval MODE='$'$NUM

  # モードが - の際はなにもしない
  if [ $MODE != "-" ]; then

    DAMMY=`echo $SERVICE_LEVEL | grep $LEVEL:$MODE`

    if [ $? -ne 0 ]; then

      if [ $MESSAGE_OUT = "false" ]; then
        MESSAGE_OUT="true" 
        echo
        echo \#\#\# サービスの設定の変更を行います。
        echo
      fi

      echo \# $CHKCONFIG --level $LEVEL $SERVICE $MODE
      $CHKCONFIG --level $LEVEL $SERVICE $MODE

      if [ $? -ne 0 ]; then
          echo
          echo \#\#\# サービスの設定変更に失敗しました。
          echo \#\#\# 終了します。
          echo
          exit $FAILED
      fi

    fi

  fi

  LEVEL=$LEVEL+1

done


# 結果の出力
if [ $MESSAGE_OUT = "false" ]; then
  echo
  echo \#\#\# サービスは既に設定済みです。
  echo \#\#\# 処理を行いません。
  echo

  RESULT=$PASSED
else
  echo
  echo \#\#\# $SERVICE サービスの設定変更を確認します。
  echo
  echo \# $CHKCONFIG --list $SERVICE

  $CHKCONFIG --list $SERVICE

  RESULT=$SUCCESS
fi


echo
echo \#\#\# $SERVICE サービスの設定変更を終了します。
echo


exit $RESULT

