#!/bin/bash -f
#
# ユーザー作成スクリプト
# ・ユーザーの作成
# ・ホームディレクトリの作成
# ・/etc/passwd によるユーザー作成確認
# ・ls によるホームディレクトリ有効確認
#
# Developed by Yasuhiro Fujitsuki 2010/1
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
WC=/usr/bin/wc 
WC_L="${WC} -l"
USERADD=/usr/sbin/useradd
MKDIR=/bin/mkdir
LS=/bin/ls
XARGS=/usr/bin/xargs
CP=/bin/cp
CHOWN=/bin/chown

# コンフィグファイル 
ETC_PASSWD=/etc/passwd
ETC_GROUP=/etc/group
# スクリプトデフォルトシェル
DEFAULT_SHELL=/bin/bash
# ホームディレクトリスケルトン
HOME_SKEL=/etc/skel
###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 6 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [User Name] [User ID] [GROUP] [NAME] [HOME] [SHELL]
  echo
  echo "[User Name] ... ユーザーアカウント"
  echo "[User ID]   ... ユーザーID"
  echo "[GROUP]     ... グループ名"
  echo "[NAME]      ... 名前\(コメント部分に追加\)"
  echo "[HOME]      ... ホームディレクトリ"
  echo "                既存ディレクトリが存在する場合、そのまま利用します"
  echo "[SHELL]     ... デフォルトシェル"
  echo "                指定シェルが存在しない場合、$DEFAULT_SHELL に置き換えます"
  exit $USAGE
fi

