#!/bin/bash -f
#
# yum を利用したパッケージのインストール
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
YUM=/usr/bin/yum
YUM_OPS_REPO="--disablerepo=* --enablerepo="
GREP="/bin/grep"

###################################

# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了

if [ $# -ne 2 ]; then
  echo 
  echo usage \> $0 [Repo] [Package]
  echo
  echo "[Repo]    ... リポジトリ名"
  echo "             default ... 標準環境を利用"
  echo "[Package] ... インストール対象パッケージ"
  echo
  exit $USAGE
fi

REPO=$1
PACKAGE=$2

# yum オプション用変数
YUM_OPS=""

# リポジトリ設定の確認
if [ ! $REPO = "default" ]; then
  YUM_OPS=${YUM_OPS_REPO}${REPO}
fi


# パッケージの存在確認作業

echo 
echo \#\#\# $PACKAGE が存在するか確認します。
echo 
echo \# ${YUM} ${YUM_OPS} info $PACKAGE

${YUM} ${YUM_OPS} info $PACKAGE

# パッケージが見付からない場合、終了
# 終了コードは PASSED
if [ $? -ne 0  ]; then
  echo
  echo \#\#\# $PACKAGE が見付かりませんでした。
  echo \#\#\# 作業を終了します。
  echo

  exit $PASSED
fi

# パッケージのインストール作業

echo 
echo \#\#\# $PACKAGE のインストールを行います。
echo 
echo \# ${YUM} -y ${YUM_OPS} install $PACKAGE

${YUM} -y ${YUM_OPS} install $PACKAGE


# パッケージの存在確認作業

echo 
echo \#\#\# $PACKAGE のインストール確認を行います。
echo 
echo \# ${YUM} ${YUM_OPS} list $PACKAGE

${YUM} ${YUM_OPS} list $PACKAGE


# パッケージが見付からない場合、終了
# 終了コードは FAILED
if [ $? -ne 0  ]; then
  echo
  echo \#\#\# $PACKAGE がインストールされませんでした。
  echo

  exit $FAILED
fi


echo
echo \#\#\# $PACKAGE のインストールを終了します。
echo

exit $SUCCESS


