#!/bin/bash
################################
# ユーザー一括削除スクリプト
#   Created by Yasuhiro Fujitsuki(thaniwa) 2010/3
################################

################################
# ユーザーデータファイルの定義
FILE="data/user_list_linux.csv"
################################


IFS=$'\n'

# ユーザー情報の読み込み 
for LINE in `cat $FILE`
do

  #######################################
  # ユーザー情報の抽出 
  #######################################

  USER_NAME=`echo $LINE | cut -d "," -f 1`

  #######################################
  # ユーザー削除
  #######################################

  echo \# userdel -rf $USER_NAME
  userdel -rf $USER_NAME

done

echo
echo
echo ユーザーの削除を終了しました。
echo
echo

