#!/bin/bash -f
#
# SSH によるユーザーログイン確認
# (ユーザーが正しく作成されたかどうかの確認を行う)
# expect コマンドが存在しない場合は評価は実施しない
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = ログインテスト成功
# 1 = ログインテスト失敗
# 9 = 実行せず/expectが存在しないため、実行を省略
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル 
EXPECT=/usr/bin/expect
SSH=/usr/bin/ssh
###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 3 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [user] [password] [host]
  echo
  echo [user] ... ユーザーID
  echo [password] ... パスワード
  echo [host] ... 接続ホスト
  exit $USAGE
fi

# ユーザー情報の設定
USER=$1
PASSWORD=$2
HOST=$3 


# expect の存在確認
# 存在しない場合、メッセージを表示し、終了
if [ ! -f $EXPECT ] || [ ! -x $EXPECT ] ; then

  echo $EXPECT が存在しません。実行を中止します。
  exit $PASSED

fi


# SSH によるログインテスト 
echo ssh ログインテストを実施します。
echo ユーザー名： $USER, ホスト: $HOST

$EXPECT -c "
spawn $SSH $USER@$HOST whoami
expect password: ; send $PASSWORD\n
expect \"try again.\" {
  send \"\\03\\n\"
  exit $FAILED
}
exit $SUCCESS"

#コマンド実行結果の取得
RESULT=$?


# 最終出力
if [ $RESULT -eq $SUCCESS ]; then
  echo ssh ログインテスト成功
  exit $SUCCESS
else
  echo ssh ログインテスト失敗
  exit $FAILED
fi

exit

