/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.modules;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.thaniwa.scriptdirector.modules.Command;
import jp.thaniwa.scriptdirector.modules.Data;
import jp.thaniwa.scriptdirector.modules.DataFile;
import jp.thaniwa.scriptdirector.modules.Scene;
import jp.thaniwa.scriptdirector.modules.SceneGroup;

public class Scenario {
    private AbstractList<DataFile> dataFileList;
    private AbstractList<SceneGroup> sceneGroupList;
    private int allStepNumber = 0;

    public void setDataFileList(AbstractList<DataFile> dataFileList) {
        this.dataFileList = dataFileList;
    }

    public void setSceneGroupList(AbstractList<SceneGroup> sceneGroupList) {
        this.sceneGroupList = sceneGroupList;
    }

    public AbstractList<DataFile> getDataFileList() {
        return this.dataFileList;
    }

    public Iterator<DataFile> getDataFileIterator() {
        Iterator<DataFile> result = null;
        if (this.dataFileList != null) {
            result = this.dataFileList.iterator();
        }
        return result;
    }

    public DataFile getDataFile(int number) {
        DataFile result = null;
        Iterator<DataFile> i = this.getDataFileIterator();
        while (i != null && i.hasNext()) {
            DataFile dataFile = i.next();
            if (dataFile.getNumber() != number) continue;
            result = dataFile;
            break;
        }
        return result;
    }

    public AbstractList<SceneGroup> getSceneGroupList() {
        return this.sceneGroupList;
    }

    public Iterator<SceneGroup> getSceneGroupIterator() {
        Iterator<SceneGroup> result = null;
        if (this.sceneGroupList != null) {
            result = this.sceneGroupList.iterator();
        }
        return result;
    }

    public void addDataFile(DataFile dataFile) {
        if (this.dataFileList == null) {
            this.dataFileList = new ArrayList<DataFile>();
        }
        this.dataFileList.add(dataFile);
    }

    public void addSceneGroup(SceneGroup sceneGroup) {
        if (this.sceneGroupList == null) {
            this.sceneGroupList = new ArrayList<SceneGroup>();
        }
        this.sceneGroupList.add(sceneGroup);
    }

    public int getAllStepNumer() {
        int result = this.allStepNumber;
        if (result == 0 && this.sceneGroupList != null) {
            for (SceneGroup sceneGroup : this.sceneGroupList) {
                Scene scene;
                int num;
                if (sceneGroup == null) continue;
                AbstractList<Scene> sceneList = sceneGroup.getSceneList();
                int sceneListNumber = 0;
                int dataFileLineNumber = 0;
                if (sceneList != null && (sceneListNumber = sceneList.size()) > 0 && (num = (scene = sceneList.get(0)).getNumber()) != 0 && this.dataFileList != null && this.dataFileList.size() > 0) {
                    for (DataFile df : this.dataFileList) {
                        if (df.getNumber() != num) continue;
                        dataFileLineNumber = df.getLineNumber();
                        break;
                    }
                }
                if (dataFileLineNumber != 0) {
                    result += sceneListNumber * dataFileLineNumber;
                    continue;
                }
                ++result;
            }
        }
        return result;
    }

    public boolean confirm() {
        boolean result = true;
        if (this.sceneGroupList != null) {
            for (SceneGroup sceneGroup : this.sceneGroupList) {
                if (sceneGroup == null) {
                    System.err.println("\u30b7\u30fc\u30f3\u30b0\u30eb\u30fc\u30d7\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    result = false;
                    break;
                }
                AbstractList<Scene> sceneList = sceneGroup.getSceneList();
                if (sceneList == null || sceneList.size() == 0) {
                    System.err.println("\u30b7\u30fc\u30f3\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    result = false;
                    break;
                }
                for (Scene s : sceneList) {
                    int dfNumber = s.getNumber();
                    if (dfNumber == 0) {
                        Command c = s.getCommand();
                        String cString = c.getLine();
                        Pattern pattern = Pattern.compile("%[1-9][0-9]*");
                        Matcher matcher = pattern.matcher(cString);
                        if (!matcher.find()) continue;
                        System.err.println("\u30b3\u30de\u30f3\u30c9\u5b9a\u7fa9\u304c\u4e0d\u6b63\u3067\u3059 : " + cString);
                        result = false;
                        break;
                    }
                    DataFile dataFile2 = null;
                    for (DataFile dataFile2 : this.dataFileList) {
                        if (dataFile2.getNumber() == dfNumber) break;
                    }
                    if (dataFile2 == null) {
                        System.err.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 \u30d5\u30a1\u30a4\u30eb\u756a\u53f7 =  " + dfNumber);
                        result = false;
                        break;
                    }
                    if (dataFile2.getDataList().size() == 0) {
                        System.err.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u3067\u3059\u3002 : " + dataFile2.getFile().getAbsolutePath());
                        result = false;
                        break;
                    }
                    Command c = s.getCommand();
                    AbstractList<Data> dlist = dataFile2.getDataList();
                    for (Data data : dlist) {
                        if (c.confirm(data.getList())) continue;
                        System.err.println("\u30b3\u30de\u30f3\u30c9\u30c7\u30fc\u30bf\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                        System.err.println("\u30b3\u30de\u30f3\u30c9\u884c : " + c.getLine());
                        System.err.println("\u30c7\u30fc\u30bf\u884c : " + data.getLine());
                        result = false;
                        break;
                    }
                    if (result) continue;
                    break;
                }
                if (result) continue;
                break;
            }
        }
        return result;
    }

    public void print() {
        System.out.println("======================");
        System.out.println("\u30b7\u30ca\u30ea\u30aa\u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        System.out.println("======================");
        if (this.dataFileList == null || this.dataFileList.isEmpty() || this.dataFileList.size() == 0) {
            System.out.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        } else {
            for (DataFile dataFile : this.dataFileList) {
                dataFile.print();
            }
        }
        if (this.sceneGroupList == null || this.sceneGroupList.isEmpty() || this.sceneGroupList.size() == 0) {
            System.out.println("\u30b7\u30fc\u30f3\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        } else {
            for (SceneGroup sceneGroup : this.sceneGroupList) {
                sceneGroup.print();
            }
        }
    }

    public AbstractList<String> getDataFileInfo() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.dataFileList == null || this.dataFileList.isEmpty() || this.dataFileList.size() == 0) {
            ((AbstractList)list).add("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        } else {
            for (DataFile dataFile : this.dataFileList) {
                ((AbstractList)list).add(dataFile.getDataFileInfo());
            }
        }
        return list;
    }
}

