#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/utility.h>

using namespace scpl;

static long counter = 0;

struct A{
	A():l(counter){++counter;}
	A(const A& a):l(a.l){}
	long l;
};
struct B : public A{
	SCPLU_DCDEF(B,A)
	SCPLU_CCDEF(B,A)
};
struct C: public B{
	SCPLU_DCDEF(C,B)
	SCPLU_CCDEF(C,B)
};

struct Data{
	int d[3];
};

inline void tu_class(){
	A a1;
	A a2(a1);
	B b1;
	B b2(b1);
	C c1;
	C c2(c1);

	SUT_ASSERT_EQUALS(Int,a1.l,a2.l);
	SUT_ASSERT_EQUALS(Int,b1.l,b2.l);
	SUT_ASSERT_EQUALS(Int,c1.l,c2.l);

	SUT_ASSERT_EQUALS(Int,a1.l,0);
	SUT_ASSERT_EQUALS(Int,b1.l,1);
	SUT_ASSERT_EQUALS(Int,c1.l,2);
	SUT_ASSERT_EQUALS(Int,counter,3);
}
inline void tu_swap(){
	int a = 1,b = 100;
	Data c,d;
	c.d[0] = 10;c.d[1] = 20;c.d[2] = 30;
	d.d[0] = 17;d.d[1] = 97;d.d[2] = 98;

	swap(a,b);
	swap(c,d);

	SUT_ASSERT_EQUALS(Int,a,100);
	SUT_ASSERT_EQUALS(Int,b,1);
	SUT_ASSERT_EQUALS(Int,c.d[0],17);
	SUT_ASSERT_EQUALS(Int,c.d[1],97);
	SUT_ASSERT_EQUALS(Int,c.d[2],98);
	SUT_ASSERT_EQUALS(Int,d.d[0],10);
	SUT_ASSERT_EQUALS(Int,d.d[1],20);
	SUT_ASSERT_EQUALS(Int,d.d[2],30);
}
inline void tu_center(){
	byte a[2]	= {0,10};
	short b[2]	= {500,1000};
	int c[2]	= {240000,0};
	long d[2]	= {-500,500};
	SUT_ASSERT_EQUALS(Int,center(a[0],a[1]),5);
	SUT_ASSERT_EQUALS(Int,center(b[0],b[1]),750);
	SUT_ASSERT_EQUALS(Int,center(c[0],c[1]),120000);
	SUT_ASSERT_EQUALS(Int,center(d[0],d[1]),0);
}

void test_utility(){
	tu_class();
	tu_swap();
	tu_center();
}