#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/find.h>

using namespace scpl;

static long table[10] = {734661,345762,23462,345276,324626,23462,7134642,75425,64325,647};

ABTMP struct ExIf : public FuncIf<A,B>{
	virtual bool operator()(const A& a,const B& b)const{return (1000 > a)||(a == b);}
};

void test_find(){
	long s = table[1];
	long *l1 = table+2,*l2 = &s;
	long *b = table,*e = table+10;

	SUT_ASSERT_EQUALS(Int,piFind(b,e,*l1),2);
	SUT_ASSERT_EQUALS(Int,piFind(b,e,*l2),-1);
	SUT_ASSERT_EQUALS(Ptr,ppFind(b,e,*l1),l1);
	SUT_ASSERT_EQUALS(Ptr,ppFind(b,e,*l2),NULL);
	SUT_ASSERT_EQUALS(Ptr,ppsFind(b,e,*l1),l1);
	SUT_ASSERT_EQUALS(Ptr,ppsFind(b,e,*l2),NULL);

	SUT_ASSERT_EQUALS(Int,diFind(b,e,*l1),2);
	SUT_ASSERT_EQUALS(Int,diFind(b,e,*l2),1);
	SUT_ASSERT_EQUALS(Int,diFindR(b,e,*l1),5);
	SUT_ASSERT_EQUALS(Int,diFindR(b,e,*l2),1);
	SUT_ASSERT_EQUALS(Ptr,dpFind(b,e,*l1),table+2);
	SUT_ASSERT_EQUALS(Ptr,dpFind(b,e,*l2),table+1);
	SUT_ASSERT_EQUALS(Ptr,dpsFind(b,e,*l1),table+2);
	SUT_ASSERT_EQUALS(Ptr,dpsFind(b,e,*l2),table+1);
	SUT_ASSERT_EQUALS(Ptr,dpFindR(b,e,*l1),table+5);
	SUT_ASSERT_EQUALS(Ptr,dpFindR(b,e,*l2),table+1);
	SUT_ASSERT_EQUALS(Ptr,dpsFindR(b,e,*l1),table+5);
	SUT_ASSERT_EQUALS(Ptr,dpsFindR(b,e,*l2),table+1);
	SUT_ASSERT_EQUALS(Int,dcFind(b,e,*l1),2);
	SUT_ASSERT_EQUALS(Int,dcFind(b,e,*l2),1);

	SUT_ASSERT_EQUALS(Int,fiFind(b,e,*l1,ExIf<long>()),2);
	SUT_ASSERT_EQUALS(Int,fiFind(b,e,*l2,ExIf<long>()),1);
	SUT_ASSERT_EQUALS(Int,fiFindR(b,e,*l1,ExIf<long>()),9);
	SUT_ASSERT_EQUALS(Int,fiFindR(b,e,*l2,ExIf<long>()),9);
	SUT_ASSERT_EQUALS(Ptr,fpFind(b,e,*l1,ExIf<long>()),table+2);
	SUT_ASSERT_EQUALS(Ptr,fpFind(b,e,*l2,ExIf<long>()),table+1);
	SUT_ASSERT_EQUALS(Ptr,fpsFind(b,e,*l1,ExIf<long>()),table+2);
	SUT_ASSERT_EQUALS(Ptr,fpsFind(b,e,*l2,ExIf<long>()),table+1);
	SUT_ASSERT_EQUALS(Ptr,fpFindR(b,e,*l1,ExIf<long>()),table+9);
	SUT_ASSERT_EQUALS(Ptr,fpFindR(b,e,*l2,ExIf<long>()),table+9);
	SUT_ASSERT_EQUALS(Ptr,fpsFindR(b,e,*l1,ExIf<long>()),table+9);
	SUT_ASSERT_EQUALS(Ptr,fpsFindR(b,e,*l2,ExIf<long>()),table+9);
	SUT_ASSERT_EQUALS(Int,fcFind(b,e,*l1,ExIf<long>()),3);
	SUT_ASSERT_EQUALS(Int,fcFind(b,e,*l2,ExIf<long>()),2);
	
}