// 
// managed_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _managed_ptr_INCLUDED_
#define _managed_ptr_INCLUDED_

#include "managed_sys.h"
#include "utility.h"
#include "exception.h"

namespace scpl{

/**
	[U[`̉s}N֐i managed_ptr NX̂݁jB
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ p łB
**/
#define managed_delete(type) template<> void scpl::managed_ptr<type>::delptr(type* p)

	/**
		̃NX́A smart_ptr ƓlɎQƃJEgA
		QƂĂSẴ|C^NXȂA|C^
		J܂B̃NX́A smart n|C^NX̌_łA
		Ƀ|C^NXɊ܂܂|C^ʂ̃|C^NXɊ܂܂Ƃ
		Ă܂B܂ALXg\łB
		ۂ̏ł́A|C^XgŊǗ̂ŁA smart n|C^NX
		|C^^֐ŏdȂ\܂B

		W̉ł delete g܂A
		L̃}N֐gp΁Ǎ^̉sƂł܂B
		zۗLAǗꍇ managed_ary NXgpĂB
	**/
	TMP class managed_ptr{
	public:
		typedef T*				ptr;
		typedef T&				ind;
		typedef const T*		cptr;
		typedef const T&		cind;
		typedef managed_ptr<T>	self;

	private:
		void delptr(T* p){delete p;}
		void dec_del(){
			if(_pm&&(_pm->dec() == 0)){
				delete _pm;
				delptr(_p);
			}
		}
		void setpointer(ptr p){
			if(p){
				bool in;
				_pm = manage_sys::manage_data::md_is(p,&in);
				if(!in) _pm = newcheck(new manage_sys::manage_data(p));
				else _pm->inc();
			}
			else _pm = NULL;
			_p = p;
		}

	public:
		/**
			Rs[RXgN^B
			[arg]
			p	: Rs[̃|C^B
		**/
		managed_ptr(const self& p):_pm(p._pm),_p(p._p){
			if(p._pm) _pm->inc();
		}

		/**
			NULL ۗL܂B
		**/
		managed_ptr():_pm(NULL),_p(NULL){}
		/**
			|C^ۗL܂B
			[arg]
			p	: ۗL|C^B
			[exc]
			std::bad_alloc	: ۗL邽߂̗̈mۂłȂB
		**/
		explicit managed_ptr(ptr p):_pm(NULL){setpointer(p);}

		/**
			fXgN^B
			QƃJEg炵A[ɂȂ
			܂B
		**/
		~managed_ptr(){dec_del();}

		/**
			|C^݂邩Ԃ܂B
			[return]
			LĂ|C^݂Ȃ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _p;}
		/**
			|C^ NULL Ԃ܂B
			[return]
			LĂ|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _p == NULL;}

		/**
			|C^v邩Ԃ܂B
			[arg]
			p	: r|C^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(cptr p)const{return p == _p;}
		bool operator==(const self& p)const{return _pm == p._pm;}
		/**
			|C^svԂ܂B
			[arg]
			p	: r|C^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(cptr p)const{return p != _p;}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/**
			w肵|C^NX܂B
			[arg]
			p	: |C^NXB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(const self& p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(ptr p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		void set(const self& p){
			dec_del();
			_pm = const_cast<manage_sys::manage_data*>(p._pm);
			_p = p._p;
			if(p._pm) _pm->inc();
		}
		void set(ptr p){
			dec_del();
			setpointer(p);
		}

		/**
			̂QƂ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind operator*()const{return *_p;}
		/**
			oQƂ܂B
			[return]
			LĂ|C^B
		**/
		ptr operator->()const{return _p;}

		/**
			̂Ԃ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind getIndirect()const{return *_p;}
		/**
			|C^Ԃ܂B
			[return]
			LĂ|C^B
		**/
		ptr get()const{return _p;}
		ptr operator~()const{return _p;}

		/**
			|C^ NULL Ԃ܂B
			[return]
			|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_p;}

		/**
			QƃJEgԂ܂B
			[return]
			QƃJEgB
		**/
		ulong count()const{return _pm?_pm->count():0;}

		/**
			|C^ւ܂B
			[arg]
			p	: ւ|C^B
		**/
		void swap(self& p){scpl::swap(_pm,p._pm);scpl::swap(_p,p._p);}

		/**
			f[^NA܂B
			NULL ̂ƓłB
		**/
		void clear(){dec_del();_pm = NULL;_p = NULL;}


	private:
		manage_sys::manage_data* _pm;
		T* _p;

	};

} // namespace scpl
#endif
