// 
// File.h
// 
// Copyright(C) 2007 Ó
#ifndef _File_INCLUDED_
#define _File_INCLUDED_
#include <share.h>
#include "scpl.h"
#include "exception.h"

/**
	stdio.h  FILE ̃JvZNXłB
	ꂼ̗prɉāA
	FileReader A FileWriter A FileBoth NXpӂ܂B

	scpl  1.0 Ƀo[WAbvA "Exceptions.h" O@\
	gȂȂ߁A֐̈߂lωĂ܂B
**/

namespace scpl{

#if SCPL_EXCEPTION_LV >= 4
#define _check_open() if(!_Fp) _THROW(scpl::invalid_call,"Not open")
#else
#define _check_open() if(!_Fp) return false
#endif /* SCPL_EXCEPTION_LV */
	/**
		t@C̊NXłB
		̃NX̃CX^X͐ł܂B
	**/
	class File{
		friend class FileBoth;
	public:
		/**
			seek ֐ŎgpV[NtOłB
		**/
		enum FILESEEK{
			FS_SET = SEEK_SET, // t@C̐擪
			FS_CUR = SEEK_CUR, // ݂̃V[Nʒu
			FS_END = SEEK_END, // t@C̏I[
		};
		/**
			LŃI[vƂɎgptOłB
		**/
		enum SHAREFRAG{
/**[hybrid]**/
#ifdef __BORLANDC__
			SF_B = SH_DENYNO, // ǂݏ\
			SF_R = SH_DENYRD, // ǂݍ݉\Aݕs
			SF_W = SH_DENYWR, // ݉\Aǂݍݕs
			SF_N = SH_DENYRW, // ǂݏs
#else
			SF_B = _SH_DENYNO,
			SF_R = _SH_DENYRD,
			SF_W = _SH_DENYWR,
			SF_N = _SH_DENYRW,
#endif
		};

	protected:
		File():_Fp(NULL),_Share(SF_N){}

		void gen_fmode(ulong mode,char(&rmode)[4]);
		void gen_fmode(ulong mode,wchar_t(&rmode)[4]);

	public:
		/**
			fXgN^B
			t@CJĂΕ܂B
		**/
		virtual ~File(){if(_Fp) fclose(_Fp);}

		/**
			t@CJĂ邩ǂԂ܂B
			[return]
			t@CJĂ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _Fp!=NULL;}

		/**
			t@C܂B
		**/
		void close(){if(_Fp){fclose(_Fp);_Fp = NULL;}}

		/**
			t@C̋L[hԂ܂B
			[return]
			t@C̋L[hB
		**/
		SHAREFRAG getShare()const{return _Share;}

		/**
			݂̃t@C|C^Ԃ܂B
			[arg]
			pos	: ݂̃t@C|C^擾ϐ̃|C^B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool getpos(fpos_t* pos){return fgetpos(_Fp,pos) == 0;}
		/**
			݂̃t@C|C^w肵܂B
			[arg]
			pos	: ݂̃t@C|C^ݒ肷ϐ̃|C^B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool setpos(fpos_t* pos){return fsetpos(_Fp,pos) == 0;}

		/**
			t@C|C^̈ʒuړ܂B
			[arg]
			offset	: ړʁB
			origin	: ړ̊_B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool seek(long offset,FILESEEK origin){return fseek(_Fp,offset,origin) == 0;}
		//! BCC ł 64bit V[N͂łȂ !//
#ifndef __BORLANDC__
		/**
			t@C|C^̈ʒuړ܂B
			[arg]
			offset	: ړʁB
			origin	: ړ̊_B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool seek64(__int64 offset,FILESEEK origin){return _fseeki64(_Fp,offset,origin) == 0;}
#endif

		/**
			tbV܂B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool flush();

		/**
			t@CJĂ邩ǂԂ܂B
			[return]
			t@CJĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool opened()const{return _Fp!=NULL;}
		/**
			G[Ă邩ǂԂ܂B
			[return]
			G[Ăꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool error()const{return (_Fp!=NULL)?(ferror(_Fp)!=0):false;}
		/**
			t@C̏I[ǂԂ܂B
			[return]
			t@C̏I[ɒBĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool eof()const{return (_Fp!=NULL)?(feof(_Fp)!=0):false;}

		/**
			{̂Ԃ܂B
			[return]
			FILE \̂ւ̃|C^B
		**/
		FILE* getStream()const{return _Fp;}
		/**
			{̂̃t@CLqqԂ܂B
			[return]
			t@CLqqB
			t@CJĂȂꍇ -1 Ԃ܂B
		**/
		int getHandle()const{return (!_Fp)?-1:_fileno(_Fp);}

	protected:
		FILE* _Fp;
		SHAREFRAG _Share;

	};

	/**
		t@C̓ǂݍ݂̒ۃNXB
	**/
	class AFileReader:virtual public File{
	protected:
		AFileReader():_IsBinary(false){}

	public:
		/**
			t@Cf[^ǂݍ݂܂B
			[arg]
			buf		: ǂݍݐ̃obt@B
			size	: ǂݍރubNTCYB
			count	: ǂݍރubNB
			[return]
			ǂݍ񂾃ubNԂ܂B
			sꍇ EOF ɒBĂꍇ 0 Ԃ܂B
		**/
		size_t read(void* buf,size_t size,size_t count=1){return fread(buf,size,count,_Fp);}
		template<class T,ulong size,size_t count>
		size_t read(T* data){return read(data,size,count);}

		/**
			ꕶǂݎ܂B
			[return]
			ꍇ ǂݎԂA
			sꍇ EOF Ԃ܂B
		**/
		int getChar(){return fgetc(_Fp);}
		/**
			ꕶǂݎ܂B
			[return]
			ꍇ ǂݎԂA
			sꍇ WEOF Ԃ܂B
		**/
		wint_t getWChar(){return fgetwc(_Fp);}

		/**
			sǂݎ܂B
			[arg]
			buf				: ǂݍݐ̃obt@B
			size			: ǂݍލő啶B
			useReturnChar	: ̍ŌɉscǂB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool getStr(str buf,int size,bool useReturnChar=false);
		bool getWStr(wstr buf,int size,bool useReturnChar=false);
		template<int size>
		bool getStr(char(&buf)[size],bool useReturnChar=false){return getStr(buf,size,useReturnChar);}
		template<int size>
		bool getWStr(wchar_t(&buf)[size],bool useReturnChar=false){return getWStr(buf,size,useReturnChar);}

		/**
			oCi[hǂԂ܂B
			[return]
			oCi[h̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isBinary()const{return _IsBinary;}

	protected:
		bool _IsBinary;

	};

	/**
		t@Cւ݂̏̒ۃNXB
	**/
	class AFileWriter:virtual public File{
	protected:
		AFileWriter():_IsBinary(false),_IsAdd(false){}

	public:
		/**
			f[^݂܂B
			[arg]
			buf		: ރobt@B
			size	: ރubNTCYB
			count	: ރubNB
			[return]
			ꍇ͏񂾃ubNԂ܂B
			sꍇ 0 Ԃ܂B
		**/
		size_t write(const void* buf,size_t size,size_t count=1){return fwrite(buf,size,count,_Fp);}
		template<class T,ulong Size,size_t count>
		size_t write(const T* data){return write(write,Size,count);}

		/**
			ꕶ݂܂B
			[arg]
			c	: ޕB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool putChar(char c){return fputc(c,_Fp) != EOF;}
		bool putWChar(wchar_t c){return fputwc(c,_Fp) != WEOF;}

		/**
			݂܂B
			[arg]
			buf				: ޕB
			size			: ޕB
			useReturnChar	: sǉ݂邩ǂB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool putStr(cstr buf,bool useReturnChar=false);
		bool putWStr(cwstr buf,bool useReturnChar=false);
		template<size_t size>
		bool putStr(char(&buf)[size],bool useReturnChar=false){return putStr(buf,size,useReturnChar);}
		template<size_t size>
		bool putWStr(char(&buf)[size],bool useReturnChar=false){return putWStr(buf,size,useReturnChar);}

		/**
			oCi[hǂԂ܂B
			[return]
			oCi[h̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isBinary()const{return _IsBinary;}
		/**
			ǉ[hǂԂ܂B
			[return]
			ǉ[h̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isAdd()const{return _IsBinary;}

	protected:
		bool _IsBinary;
		bool _IsAdd;

	};

	/**
		t@Cǂݍ݃NXłB
	**/
	class FileReader:public AFileReader{
	public:
		/**
			CX^X쐬܂B
		**/
		FileReader(){}

		/**
			t@Cw肵IvVŃI[v܂B
			[arg]
			fname	: I[vt@CB
			binary	: oCi[hŊJǂB
			shflag	: L[hB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
			[note]
			łɊJĂt@C݂ĂꍇA
			w肵t@CĴɐÃt@C܂B
		**/
		bool open(cstr fname,bool binary = false,SHAREFRAG shflag = SF_N);
		bool open(cwstr fname,bool binary = false,SHAREFRAG shflag = SF_N);

	};

	/**
		t@C݃NX
	**/
	class FileWriter:public AFileWriter{
	public:
		/**
			CX^X쐬܂B
		**/
		FileWriter(){}

		/**
			t@Cw肵IvVŃI[v܂B
			[arg]
			fname	: I[vt@CB
			binary	: oCi[hŊJǂB
			add		: ǉ[hŊJǂB
			shflag	: L[hB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
			[note]
			łɊJĂt@C݂ĂꍇA
			w肵t@CĴɐÃt@C܂B
		**/
		bool open(cstr fname,bool binary = false,bool add = false,SHAREFRAG shflag = SF_N);
		bool open(cwstr fname,bool binary = false,bool add = false,SHAREFRAG shflag = SF_N);

	};

	/**
		ǂݏ̃[hŃt@CI[vt@CNXłB
		ǂݏ֐̐ɂĂ͂ꂼ
		AFileReader NXA AFileWriter NXQƂĂB
	**/
	class FileBoth:virtual public AFileReader,virtual public AFileWriter{
	public:
		/**
			CX^X쐬܂B
		**/
		FileBoth(){}

		/**
			t@Cw肵IvVŃI[v܂B
			[arg]
			fname	: I[vt@CB
			exist	:
			t@C݂ĂȂ΂ȂȂǂB
			add  true ̏ꍇ́ÃtO͖܂B
			binary	: oCi[hŊJǂB
			add		: ǉ[hŊJǂB
			shflag	: L[hB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
			[note]
			łɊJĂt@C݂ĂꍇA
			w肵t@CĴɐÃt@C܂B
		**/
		bool open(cstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shflag = SF_N);
		bool open(cwstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shflag = SF_N);

	};

} // namespace scpl
#endif
