#include "stdafx.h"
#include "..\scpl/frag.h"

using namespace scpl;
void test_frag(){
#ifndef __BORLANDC__
	ui64 ia=0x1873057c0e816abfLL,ib=0x9a67e8d61cd9b09aLL;
#endif
	ulong la=0x12345678,lb=0x9abcdef0,lc=0xcdcdcdcd;
	ushort sa=0x1357,sb=0x9bdf,sc=0x8888;
	uchar ba=0x11,bb=0xdd,bc=0xcd;
	ushort Sa,Sb;
	uchar Ba,Bb,Bc,Bd;

	SUT_ASSERT_EQUALS(Hex,lmake2(sa,sa),0x13571357);
	SUT_ASSERT_EQUALS(Hex,lmake2(sa,sb),0x13579bdf);
	SUT_ASSERT_EQUALS(Hex,lmake2(sa,sc),0x13578888);
	SUT_ASSERT_EQUALS(Hex,lmake2(sb,sa),0x9bdf1357);
	SUT_ASSERT_EQUALS(Hex,lmake2(sb,sb),0x9bdf9bdf);
	SUT_ASSERT_EQUALS(Hex,lmake2(sb,sc),0x9bdf8888);
	SUT_ASSERT_EQUALS(Hex,lmake2(sc,sa),0x88881357);
	SUT_ASSERT_EQUALS(Hex,lmake2(sc,sb),0x88889bdf);
	SUT_ASSERT_EQUALS(Hex,lmake2(sc,sc),0x88888888);
	SUT_ASSERT_EQUALS(Hex,lmake4(ba,bb,bc,ba),0x11ddcd11);
	SUT_ASSERT_EQUALS(Hex,lmake4(ba,ba,ba,ba),0x11111111);
	SUT_ASSERT_EQUALS(Hex,lmake4(bb,bc,ba,bc),0xddcd11cd);
	SUT_ASSERT_EQUALS(Hex,lmake4(bc,ba,bb,bb),0xcd11dddd);
	SUT_ASSERT_EQUALS(Hex,smake2(ba,bb),0x11dd);
	SUT_ASSERT_EQUALS(Hex,smake2(bb,bc),0xddcd);
	SUT_ASSERT_EQUALS(Hex,smake2(bc,ba),0xcd11);
	lsplit2(la,Sa,Sb);
	SUT_ASSERT_EQUALS(Hex,Sa,0x1234);
	SUT_ASSERT_EQUALS(Hex,Sb,0x5678);
	lsplit4(lb,Ba,Bb,Bc,Bd);
	SUT_ASSERT_EQUALS(Hex,Ba,0x9a);
	SUT_ASSERT_EQUALS(Hex,Bb,0xbc);
	SUT_ASSERT_EQUALS(Hex,Bc,0xde);
	SUT_ASSERT_EQUALS(Hex,Bd,0xf0);
	
	SUT_ASSERT_EQUALS(Hex,lget2_up(la),0x1234);
	SUT_ASSERT_EQUALS(Hex,lget2_up(lb),0x9abc);
	SUT_ASSERT_EQUALS(Hex,lget2_un(la),0x5678);
	SUT_ASSERT_EQUALS(Hex,lget2_un(lc),0xcdcd);
	SUT_ASSERT_EQUALS(Hex,lget4_24(lb),0x9a);
	SUT_ASSERT_EQUALS(Hex,lget4_24(lc),0xcd);
	SUT_ASSERT_EQUALS(Hex,lget4_16(la),0x34);
	SUT_ASSERT_EQUALS(Hex,lget4_16(lc),0xcd);
	SUT_ASSERT_EQUALS(Hex,lget4_8(lb),0xde);
	SUT_ASSERT_EQUALS(Hex,lget4_8(lc),0xcd);
	SUT_ASSERT_EQUALS(Hex,lget4_0(la),0x78);
	SUT_ASSERT_EQUALS(Hex,lget4_0(lb),0xf0);
	SUT_ASSERT_EQUALS(Hex,sget2_up(sa),0x13);
	SUT_ASSERT_EQUALS(Hex,sget2_up(sb),0x9b);
	SUT_ASSERT_EQUALS(Hex,sget2_un(sb),0xdf);
	SUT_ASSERT_EQUALS(Hex,sget2_un(sc),0x88);

	SUT_ASSERT(Hex,!isFragOnBit(lb,0));
	SUT_ASSERT(Hex,isFragOnBit(sc,7));
	SUT_ASSERT(Hex,!isFragOnAll<ulong>(lc,0x00cd00dc));
	SUT_ASSERT(Hex,isFragOnAll<uchar>(bc,0x0d));
	SUT_ASSERT(Hex,!isFragOnOr<ulong>(la,0x80000000));
	SUT_ASSERT(Hex,isFragOnOr<uchar>(ba,0xf0));
	SUT_ASSERT_EQUALS(Hex,fragRev<ulong>(lc),0x32323232);
	SUT_ASSERT_EQUALS(Hex,fragRev<ushort>(sa),0xeca8);
	SUT_ASSERT_EQUALS(Hex,fragRev<ulong>(la,0x00ff00ff),0x12cb5687);
	SUT_ASSERT_EQUALS(Hex,fragRev<ushort>(sb,0x0ff0),0x942f);

#ifndef __BORLANDC__
	SUT_ASSERT(Hex,i64make2(lb,lc) == 0x9abcdef0cdcdcdcdLL);
#endif
}
