#include "stdafx.h"
#include "..\scpl/String.h"

using namespace scpl;
void test_String(){
	{
		// AString
		AString a,b(100),c("test string"),d("string test",5);
		SUT_ASSERT(Int,!a);
		SUT_ASSERT(Int,!b);
		SUT_ASSERT(Int,_I(static_cast<cstr>(c)));
		SUT_ASSERT(Int,!d.empty());
		SUT_ASSERT_EQUALS(Int,a.capacity(),0);
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),100);
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,c.capacity(),12);
		SUT_ASSERT_EQUALS(Int,c.count(),11);
		SUT_ASSERT_EQUALS(Int,d.capacity(),6);
		SUT_ASSERT_EQUALS(Int,d.count(),5);
		a = "TEST";
		SUT_ASSERT_EQUALS(Int,a.capacity(),5);
		SUT_ASSERT_EQUALS(Int,a.count(),4);
		b = static_cast<long>(180);
		SUT_ASSERT_EQUALS(Int,b.capacity(),100);
		SUT_ASSERT_EQUALS(Int,b.count(),3);
		d = b + a + "!";
		SUT_ASSERT_EQUALS(Int,d.capacity(),9);
		SUT_ASSERT_EQUALS(Int,d.count(),8);
		SUT_ASSERT_EQUALS(Int,d[7],'!');
		SUT_ASSERT_EQUALS(Int,d[8],'\0');
		SUT_ASSERT_EQUALS(Int,b.atFirst(),'1');
		SUT_ASSERT_EQUALS(Int,b.atLast(),'0');
		c.insertChar('!',4);
		SUT_ASSERT_EQUALS(Int,c.capacity(),13);
		SUT_ASSERT_EQUALS(Int,c.count(),12);
		SUT_ASSERT_EQUALS(Int,c.at(4),'!');
		c.removeAt(5);
		SUT_ASSERT_EQUALS(Int,c.capacity(),13);
		SUT_ASSERT_EQUALS(Int,c.count(),11);
		SUT_ASSERT_EQUALS(Int,c.at(5),'s');
		c.insertStr("data",-1,4);
		SUT_ASSERT_EQUALS(Int,c.capacity(),16);
		SUT_ASSERT_EQUALS(Int,c.count(),15);
		SUT_ASSERT_EQUALS(Int,c.at(4),'d');
		SUT_ASSERT(Int,c.outputNum(0xf9,16));
		SUT_ASSERT_EQUALS(Int,c.capacity(),18);
		SUT_ASSERT_EQUALS(Int,c.count(),17);
		SUT_ASSERT_EQUALS(Int,c.atLast(),'9');
		a.swap(d);
		SUT_ASSERT_EQUALS(Int,a.capacity(),9);
		SUT_ASSERT_EQUALS(Int,a.count(),8);
		SUT_ASSERT_EQUALS(Int,d.capacity(),5);
		SUT_ASSERT_EQUALS(Int,d.count(),4);
		d = c;
		SUT_ASSERT(Int,d == c);
		b.adjust(0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),4);
		a.clear(true);
		b.clear(true);
		c.clear();
		d.clear();
		SUT_ASSERT_EQUALS(Int,a.capacity(),9);
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),4);
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,c.capacity(),0);
		SUT_ASSERT_EQUALS(Int,c.count(),0);
		SUT_ASSERT_EQUALS(Int,d.capacity(),0);
		SUT_ASSERT_EQUALS(Int,d.count(),0);
		a = "180180180180F";
		SUT_ASSERT(Int,a == "180180180180F");
		SUT_ASSERT(Int,a != "180180180180f");

		// access check
		{
			AString* x = &a;
			const AString* cx = &a;
			char i;
			
			i = x->at(2);
			i = x->atFirst();
			i = x->atLast();
			
			i = cx->at(2);
			i = cx->atFirst();
			i = cx->atLast();
		}
	}
	{
		// WString
		scpl::WString a,b(100),c(L"test string"),d(L"string test",5);
		SUT_ASSERT(Int,!a);
		SUT_ASSERT(Int,!b);
		SUT_ASSERT(Int,_I(static_cast<cwstr>(c)));
		SUT_ASSERT(Int,!d.empty());
		SUT_ASSERT_EQUALS(Int,a.capacity(),0);
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),100);
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,c.capacity(),12);
		SUT_ASSERT_EQUALS(Int,c.count(),11);
		SUT_ASSERT_EQUALS(Int,d.capacity(),6);
		SUT_ASSERT_EQUALS(Int,d.count(),5);
		a = L"TEST";
		SUT_ASSERT_EQUALS(Int,a.capacity(),5);
		SUT_ASSERT_EQUALS(Int,a.count(),4);
		b = static_cast<long>(180);
		SUT_ASSERT_EQUALS(Int,b.capacity(),100);
		SUT_ASSERT_EQUALS(Int,b.count(),3);
		d = b + a + L"!";
		SUT_ASSERT_EQUALS(Int,d.capacity(),9);
		SUT_ASSERT_EQUALS(Int,d.count(),8);
		SUT_ASSERT_EQUALS(Int,d[7],L'!');
		SUT_ASSERT_EQUALS(Int,d[8],L'\0');
		SUT_ASSERT_EQUALS(Int,b.atFirst(),'1');
		SUT_ASSERT_EQUALS(Int,b.atLast(),'0');
		c.insertChar(L'!',4);
		SUT_ASSERT_EQUALS(Int,c.capacity(),13);
		SUT_ASSERT_EQUALS(Int,c.count(),12);
		SUT_ASSERT_EQUALS(Int,c.at(4),L'!');
		c.removeAt(5);
		SUT_ASSERT_EQUALS(Int,c.capacity(),13);
		SUT_ASSERT_EQUALS(Int,c.count(),11);
		SUT_ASSERT_EQUALS(Int,c.at(5),L's');
		c.insertStr(L"data",-1,4);
		SUT_ASSERT_EQUALS(Int,c.capacity(),16);
		SUT_ASSERT_EQUALS(Int,c.count(),15);
		SUT_ASSERT_EQUALS(Int,c.at(4),L'd');
		SUT_ASSERT(Int,c.outputNum(0xf9,16));
		SUT_ASSERT_EQUALS(Int,c.capacity(),18);
		SUT_ASSERT_EQUALS(Int,c.count(),17);
		SUT_ASSERT_EQUALS(Int,c.atLast(),L'9');
		a.swap(d);
		SUT_ASSERT_EQUALS(Int,a.capacity(),9);
		SUT_ASSERT_EQUALS(Int,a.count(),8);
		SUT_ASSERT_EQUALS(Int,d.capacity(),5);
		SUT_ASSERT_EQUALS(Int,d.count(),4);
		d = c;
		SUT_ASSERT(Int,d == c);
		b.adjust(0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),4);
		a.clear(true);
		b.clear(true);
		c.clear();
		d.clear();
		SUT_ASSERT_EQUALS(Int,a.capacity(),9);
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),4);
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,c.capacity(),0);
		SUT_ASSERT_EQUALS(Int,c.count(),0);
		SUT_ASSERT_EQUALS(Int,d.capacity(),0);
		SUT_ASSERT_EQUALS(Int,d.count(),0);
		a = L"180180180180F";
		SUT_ASSERT(Int,a == L"180180180180F");
		SUT_ASSERT(Int,a != L"180180180180f");

		// access check
		{
			scpl::WString* x = &a;
			const scpl::WString* cx = &a;
			wchar_t i;
			
			i = x->at(2);
			i = x->atFirst();
			i = x->atLast();
			
			i = cx->at(2);
			i = cx->atFirst();
			i = cx->atLast();
		}
	}
}
