#include "stdafx.h"
#include "..\scpl/EventList.h"
using namespace scpl;

struct TClass0{
	int i;
	TClass0():i(0){}
	void callFunc1(){i = 100;}
	void callFunc2(){i = 200;}
};
struct TClass1{
	int i;
	TClass1():i(0){}
	void callFunc1(int _i){i = _i;}
	void callFunc2(int _i){i = -_i;}
};
struct TClass2{
	int i;
	TClass2():i(0){}
	void callFunc1(int _i1,int _i2){i = _i1+_i2;}
	void callFunc2(int _i1,int _i2){i = -_i1+_i2;}
};
void test_EventList(){
	EventList0 el0;
	EventList1<int> el1;
	EventList2<int,int> el2;
	TClass0 a0,b0;
	TClass1 a1,b1;
	TClass2 a2,b2;
	CallBack0v* _0 = createCallBack<TClass0>(&TClass0::callFunc1,&a0);
	CallBack1v<int>* _1 = createCallBack<TClass1>(&TClass1::callFunc2,&a1);
	CallBack2v<int,int>* _2 = createCallBack<TClass2>(&TClass2::callFunc2,&b2);

	el0.add(_0);
	el0.add(createCallBack<TClass0>(&TClass0::callFunc2,&b0));
	el0.add(createCallBack<TClass0>(&TClass0::callFunc1,&b0));
	el0.add(createCallBack<TClass0>(&TClass0::callFunc2,&a0));

	el1.add(createCallBack<TClass1>(&TClass1::callFunc1,&a1));
	el1.add(createCallBack<TClass1>(&TClass1::callFunc2,&b1));
	el1.add(_1);
	el1.add(createCallBack<TClass1>(&TClass1::callFunc1,&b1));

	el2.add(createCallBack<TClass2>(&TClass2::callFunc1,&a2));
	el2.add(createCallBack<TClass2>(&TClass2::callFunc2,&a2));
	el2.add(createCallBack<TClass2>(&TClass2::callFunc1,&b2));
	el2.add(_2);

	el0();
	el1(150);
	el2(150,125);
	SUT_ASSERT_EQUALS(Int,a0.i, 200);
	SUT_ASSERT_EQUALS(Int,b0.i, 100);
	SUT_ASSERT_EQUALS(Int,a1.i,-150);
	SUT_ASSERT_EQUALS(Int,b1.i, 150);
	SUT_ASSERT_EQUALS(Int,a2.i, -25);
	SUT_ASSERT_EQUALS(Int,b2.i, -25);

	SUT_ASSERT(Int,el0.remove(_0));
	SUT_ASSERT(Int,el1.remove(_1));
	SUT_ASSERT(Int,el2.remove(_2));
	SUT_ASSERT(Int,!el2.remove(createCallBack<TClass2>(&TClass2::callFunc1,&a2)));

	el0();
	el1(150);
	el2(150,125);
	SUT_ASSERT_EQUALS(Int,a0.i,200);
	SUT_ASSERT_EQUALS(Int,b0.i,100);
	SUT_ASSERT_EQUALS(Int,a1.i,150);
	SUT_ASSERT_EQUALS(Int,b1.i,150);
	SUT_ASSERT_EQUALS(Int,a2.i,-25);
	SUT_ASSERT_EQUALS(Int,b2.i,275);
}