#include "stdafx.h"
#include "..\scpl/Chain.h"
#include "testClass.h"

using namespace scpl;

int _i=0;

void enum_func(const int* i){
	SUT_ASSERT_EQUALS(Int,*i,_i);
	++_i;
}

class Cls{
public:
	void enum_func(const int* i){
		SUT_ASSERT_EQUALS(Int,*i,_i);
		if(--_i<0) _i = 99;
	}
};

void test_Chain(){
	Chain<int>* cd[100];
	Chain<int>* it = NULL;
	for(int i=0;i<100;++i){
		cd[i] = new Chain<int>(smart_ptr<int>(new int(i)));
		if(it){
			it->insertToNext(cd[i]);
			it = cd[i];
		}
		else it = *cd;
	}
	{
		const Chain<int>* m = *cd;
		int i = 0;
		do{
			int _n = (i+1)%100;
			int _p = (i-1<0)?(99-i):(i-1);
			SUT_ASSERT_EQUALS(Int,*m->get(),i);
			SUT_ASSERT(Int,m->next() == cd[_n]);
			SUT_ASSERT(Int,m->prev() == cd[_p]);
			m = m->next();
			++i;
		}while(m != it);
	}
	for(int i=0;i<100;++i) delete cd[i];
}
void test_DChain(){
	DChain<LCLS> cd[100];
	DChain<LCLS>* it = NULL;
	for(int i=0;i<100;++i){
		if(it){
			it->insertToNext(cd+i);
			it = cd+i;
		}
		else it = cd;
	}
	{
		const DChain<LCLS>* m = cd;
		int i = 0;
		do{
			int _n = (i+1)%100;
			int _p = (i-1<0)?(99-i):(i-1);
			SUT_ASSERT(Int,m->next() == cd+_n);
			SUT_ASSERT(Int,m->prev() == cd+_p);
			m = m->next();
			++i;
		}while(m != it);
	}
}
