#include "stdafx.h"
#include "..\scpl/Buffer.h"

using namespace scpl;
#ifndef __BORLANDC__
typedef Buffer<uchar> ByteBuffer;
#else
#define ByteBuffer Buffer<uchar>
#endif
void test_Buffer(){
	{
		uchar list[8]={0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef};
		ByteBuffer a;
		ByteBuffer b(80);
		ByteBuffer c(120,true);
		ByteBuffer d(list,8);
#if (defined(_MSC_VER)&&(_MSC_VER>=1400)) || defined(_BORLANDC_)
		ByteBuffer e(list);
#else
		ByteBuffer e(list,8);
#endif
		ByteBuffer f(b);
		
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.count(),80);
		SUT_ASSERT_EQUALS(Int,c.count(),120);
		SUT_ASSERT_EQUALS(Int,d.count(),8);
		SUT_ASSERT_EQUALS(Int,e.count(),8);
		SUT_ASSERT_EQUALS(Int,f.count(),80);
		SUT_ASSERT_EQUALS(Int,c.count(),c.size());
		SUT_ASSERT(Int,b == f);
		SUT_ASSERT(Int,d == e);
		SUT_ASSERT(Int,!a);
		SUT_ASSERT(Int,!b.empty());
		SUT_ASSERT_EQUALS(Int,*c.get(),0);
		SUT_ASSERT_EQUALS(Int,*d.get(),1);
		SUT_ASSERT_EQUALS(Int,*(e.get()+3),0x67);
		SUT_ASSERT_EQUALS(Int,_I(a.get()),NULL);

		a.aResize(128,true);
		b.aResize(128);
		c.rResize(-28);
		d.rResize(-8);
		e.rResize(128,true);
		f.rResize(-80);

		SUT_ASSERT_EQUALS(Int,a.count(),128);
		SUT_ASSERT_EQUALS(Int,b.count(),128);
		SUT_ASSERT_EQUALS(Int,c.count(),92);
		SUT_ASSERT_EQUALS(Int,d.count(),0);
		SUT_ASSERT_EQUALS(Int,e.count(),136);
		SUT_ASSERT_EQUALS(Int,f.count(),0);
		SUT_ASSERT_EQUALS(Int,_I(f.get()),NULL);
		SUT_ASSERT_EQUALS(Int,*a.get(),0);
		SUT_ASSERT_EQUALS(Int,e.get()[7],0xef);
		SUT_ASSERT_EQUALS(Int,e.get()[8],0);
		SUT_ASSERT_EQUALS(Int,_I(d.get()),NULL);
		SUT_ASSERT(Int,!f);

		b = e;
		c.clear();

		SUT_ASSERT(Int,b == e);
		SUT_ASSERT_EQUALS(Int,_I(c.get()),NULL);

		a.swap(c);

		SUT_ASSERT(Int,a.empty());
		SUT_ASSERT_EQUALS(Int,*c.get(),0);

		uchar *rb = c.begin(),*re = c.rbegin();
		const uchar *Rb = a.begin(),*Re = a.end();

		SUT_ASSERT_EQUALS(Int,c.toPos(rb),0);
		SUT_ASSERT_EQUALS(Int,c.toPos(re),127);
		SUT_ASSERT_EQUALS(Int,*rb,*re);
		try{SUT_ASSERT_EQUALS(Int,a.toPos(Rb),1);}
		catch(InvalidParamExc e){}
		try{SUT_ASSERT_EQUALS(Int,a.toPos(Re),1);}
		catch(InvalidParamExc e){}
		try{
			uchar *i = e.begin(),*n = e.end();
			for(long j=0;i<n;++i,++j){
				if(j<8){
					SUT_ASSERT_EQUALS(Int,*i,list[j]);
				}
				else{
					SUT_ASSERT_EQUALS(Int,*i,0);
				}
			}
		}
		catch(InvalidParamExc){SUT_ASSERT(Int,false);}
		try{
			uchar *i = e.rbegin(),*n = e.rend();
			for(long j=135;n<i;--i,--j){
				if(j<8){
					SUT_ASSERT_EQUALS(Int,*i,list[j]);
				}
				else{
					SUT_ASSERT_EQUALS(Int,*i,0);
				}
			}
		}
		catch(InvalidParamExc){SUT_ASSERT(Int,false);}
	}
}
