// 
// WString.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/WString.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

namespace scpl{

	inline ulong _cap(ulong x){return (x==0)?0:x-1;}
#define _CAP _cap(capacity())
	wchar_t& WString::at(ulong i)const throw(InvalidParamExc,InvalidCallExc){
		if(i < _UseCount) return *(_Text.get() + i);
		if(empty()) throw InvalidCallExc();
		throw InvalidParamExc(1);
	}
	WString& WString::insertChar(wchar_t c,ulong index)throw(InvalidParamExc,OutOfMemExc){
		if(index > _UseCount) throw InvalidParamExc(1);
		if(_CAP == _UseCount){
			_Text.aResize(_UseCount + 2,true);
		}
		wstr pos = _Text.get() + index;
		if(index != _UseCount){
			memmove(pos + 1,pos,(_UseCount - index) * sizeof(wchar_t));
		}
		*pos = c;
		++_UseCount;
		return *this;
	}
	bool WString::outputChar(wchar_t c){
		bool suc = true;
		try{
			if(_CAP == _UseCount){
				_Text.aResize(_UseCount + 2,true);
			}
			*(_Text.get() + _UseCount++) = c;
		}
		catch(...){suc = false;}
		return suc;
	}
	WString& WString::insertStr(cwstr text,long count,ulong index)throw(InvalidParamExc,OutOfMemExc){
		if(text && (count != 0)){
			if(index > _UseCount) throw InvalidParamExc(3);
			if(count < 0) count = static_cast<long>(wcslen(text));
			long cp = _UseCount+count+1;
			if(static_cast<ulong>(cp) > _CAP) _Text.aResize(cp,true);
			wstr pos = _Text.get() + index;
			if(index != _UseCount){
				memmove(pos + count,pos,(_UseCount - index) * sizeof(wchar_t));
			}
			memcpy(pos,text,count * sizeof(wchar_t));
			_UseCount += count;
			*(_Text.get()+_UseCount) = 0;
		}
		return *this;
	}
	bool WString::outputStr(cwstr text){
		bool suc = true;
		try{
			ulong s = static_cast<ulong>(wcslen(text));
			if(0 < s){
				long cp = _CAP - _UseCount - s;
				if(cp < 0) _Text.rResize(-cp + 1,true);
				memcpy(_Text.get() + _UseCount,text,s * sizeof(wchar_t));
				_UseCount += s;
			}
			else suc = false;
		}
		catch(...){suc = false;}
		return suc;
	}

	WString& WString::insertNum(long l,ulong index,long radix)throw(InvalidParamExc,OutOfMemExc){
		wchar_t buf[32];
		if((radix < 2)||(36 < radix)) throw InvalidParamExc(3);
		memset(buf,0,32 * sizeof(wchar_t));
		_ltow(l,buf,radix);
		return insertStr(buf,-1,index);
	}
	bool WString::outputNum(long l,long radix){
		try{lastInNum(l,radix);}
		catch(...){return false;}
		return true;
	}
	WString& WString::insertUNum(ulong l,ulong index,long radix)throw(InvalidParamExc,OutOfMemExc){
		wchar_t buf[32];
		if((radix < 2)||(36 < radix)) throw InvalidParamExc(3);
		memset(buf,0,32 * sizeof(wchar_t));
		_ultow(l,buf,radix);
		return insertStr(buf,-1,index);
	}
	bool WString::outputUNum(ulong l,long radix){
		try{lastInUNum(l,radix);}
		catch(...){return false;}
		return true;
	}
	bool WString::output(const self& text){
		bool suc = true;
		try{
			if(0 < text.count()){
				long cp = _CAP - _UseCount - text.count();
				if(cp < 0) _Text.rResize(-cp + 1,true);
				memcpy(_Text.get() + _UseCount,text,text.count() * sizeof(wchar_t));
				_UseCount += text.count();
			}
			else suc = false;
		}
		catch(...){suc = false;}
		return suc;
	}
	void WString::removeAt(ulong index)throw(InvalidParamExc,InvalidCallExc){
		if(index >= _UseCount) throw InvalidParamExc(1);
		if(_UseCount == 0) throw InvalidCallExc();
		wstr pos = _Text.get() + index;
		if(index != --_UseCount){
			memmove(pos,pos + 1,(_UseCount - index) * sizeof(wchar_t));
		}
		*(_Text.get() + _UseCount) = 0;
	}
	void WString::erage(ulong indexL,ulong indexR)throw(InvalidParamExc,InvalidCallExc){
		if(indexL >= indexR) throw InvalidParamExc(1);
		if(_UseCount == 0) throw InvalidCallExc();
		if(indexR > _UseCount) throw InvalidParamExc(2);
		if(indexR != _UseCount){
			memmove(_Text.get() + indexL,_Text + indexR,(_UseCount - indexR) * sizeof(wchar_t));
		}
		memset(_Text.get() + (_UseCount - indexR + indexL),0,(indexR - indexL) * sizeof(wchar_t));
		_UseCount -= (indexR - indexL);
	}
	void WString::clear(bool noClearCapacity){
		_UseCount = 0;
		if(!noClearCapacity) _Text.clear();
		else if(_Text) *_Text.get() = 0;
	}
	void WString::copy(cwstr s,long count)throw(OutOfMemExc){
		if(s && (count != 0)){
			if(count < 0) count = static_cast<long>(wcslen(s));
			if(static_cast<ulong>(count+1) > _CAP){
				_Text.aResize(count+1,true);
			}
			else *(_Text.get()+count) = 0;
			memcpy(_Text.get(),s,count*sizeof(wchar_t));
			_UseCount = count;
		}
		else clear(false);
	}
	bool WString::equals(cwstr s)const{return (wcscmp(_Text,s) == 0);}
	long WString::find(wchar_t c)const{
		cwstr a = wcschr(_Text,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	long WString::find(cwstr c)const{
		cwstr a = wcsstr(_Text,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	void WString::toLower(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<wchar_t>(tolower(*(_Text + i)));
		}
	}
	void WString::toUpper(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<wchar_t>(toupper(*(_Text + i)));
		}
	}

	WString WString::strcat(cwstr a,cwstr b)throw(OutOfMemExc){
		size_t as = wcslen(a),bs = wcslen(b);
		WString string(static_cast<ulong>(as+bs+1));
		string = a;
		string += b;
		return WString(string._Text,string._UseCount);
	}

	bool operator==(const WString& l,const WString& r){return l.equals(r);}
	bool operator==(cwstr l,const WString& r){return r.equals(l);}
	bool operator==(const WString& l,cwstr r){return l.equals(r);}
	bool operator!=(const WString& l,const WString& r){return !l.equals(r);}
	bool operator!=(cwstr l,const WString& r){return !r.equals(l);}
	bool operator!=(const WString& l,cwstr r){return !l.equals(r);}

}
