// 
// Exceptions.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/Exceptions.h"
#include <stdarg.h>
#include <string.h>
#include <windows.h>
#include <winnt.h>

namespace scpl{
#ifdef _UNICODE
#define xshlen wcslen
#define xshcpy wcscpy
#define vsxprintf vswprintf
#else
#define xshlen strlen
#define xshcpy strcpy
#define vsxprintf vsprintf
#endif

	void Exc::setMessage(ctstr txt){
		if(txt){
			_Mes = static_cast<ctstr>(malloc((xshlen(txt)+1)*sizeof(tchar)));
			if(_Mes) xshcpy(const_cast<tstr>(_Mes),txt);
			_DoDel = (_Mes!=NULL);
		}
	}

	void Exc::setMessage(size_t maxSize,ctstr txt,...){
		tstr buf = static_cast<tstr>(malloc(maxSize*sizeof(tchar)));
		if(buf){
			int s;
			va_list v;
			va_start(v,txt);
			s = vsxprintf(buf,txt,v);
			va_end(v);
			if(0 < s){
				_Mes = static_cast<ctstr>(malloc((s+1)*sizeof(tchar)));
				if(_Mes) xshcpy(const_cast<tstr>(_Mes),buf);
				_DoDel = (_Mes!=NULL);
			}
			else _DoDel = false;
			free(buf);
		}
	}

	IOExc::IOExc(IOExc::Param p):Exc(p){
		tstr s;
		switch(p){
			case NOT_OPEN:	s = TC("t@CJĂ܂B");break;
			case SEEK:		s = TC("V[NɎs܂B");break;
			case FLUSH:		s = TC("tbVɎs܂B");break;
			case NO_OPEN:	s = TC("t@C͊J܂łB");break;
			case OPENED:	s = TC("ɊJĂt@C܂B");break;
			case READ:		s = TC("ǂݏoɎs܂B");break;
			case WRITE:		s = TC("݂Ɏs܂B");break;
			case ENDOFSEEK:	s = TC("t@C̏I[ɒB܂B");break;
			default:		s = TC("sȓo͗OłB");break;
		}
		setMessage(s,0);
	}

	void WinAPIExc::WinAPIExc_construct(){
		tstr str;
		FormatMessage(
			FORMAT_MESSAGE_ALLOCATE_BUFFER|
			FORMAT_MESSAGE_FROM_SYSTEM|
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,code(),
			LANG_USER_DEFAULT,
			(tstr)&str,
			0,NULL
		);
		setMessage(str);
		LocalFree(str);
	}

	WinAPIExc::WinAPIExc():Exc(0){
		setCode(GetLastError());
		WinAPIExc_construct();
	}

} // namespace scpl
