// 
// Argument.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/Argument.h"
#include <string.h>
#include <wchar.h>
#include <windows.h>
#include <shlwapi.h>

#ifdef __BORLANDC__
#define _strdup strdup
#endif
namespace scpl{

	namespace argument{

		ArgVA* createArgumentA(cstr txt,cstr divide,bool isQuote)throw(InvalidParamExc,OutOfMemExc){
			ulong len;
			AString s;
			char c;
			bool isArg = false;
			bool isSQuoteIn = false;
			bool isDQuoteIn = false;
			ArgVA* v;

			if(!txt) throw InvalidParamExc(1);
			if(!divide) divide = " \t\n";
			else if(strchr(divide,'"')||strchr(divide,'\'')){
				throw InvalidParamExc(2);
			}
			v = checkNull(new ArgVA());
			len = static_cast<ulong>(strlen(txt));

			for(ulong i=0;i<=len;++i){
				c = *(txt + i);
				if(isArg){
					if(isQuote&&(isSQuoteIn||isDQuoteIn)){
						if((isSQuoteIn&&(c=='\''))||(isDQuoteIn&&(c=='"'))){
							isSQuoteIn = isDQuoteIn = isArg = false;
							v->lastIn(s);
							s.clear(false);
						}
						else s.lastInChar(c);
					}
					else if(strchr(divide,c)){
						isArg = false;
						v->lastIn(s);
						s.clear(false);
					}
					else s.lastInChar(c);
				}
				else if(strchr(divide,c)) continue;
				else if(isQuote&&(c=='\'')) isSQuoteIn = isArg = true;
				else if(isQuote&&(c=='"'))  isDQuoteIn = isArg = true;
				else{
					isArg = true;
					s.lastInChar(c);
				}
			}
			if(isArg) v->lastIn(s);
			return v;
		}
		ArgVW* createArgumentW(cwstr txt,cwstr divide,bool isQuote)throw(InvalidParamExc,OutOfMemExc){
			ulong len;
			WString s;
			wchar_t c;
			bool isArg = false;
			bool isSQuoteIn = false;
			bool isDQuoteIn = false;
			ArgVW* v;
//			printf("1");
			if(!txt) throw InvalidParamExc(1);
			if(!divide) divide = L" \t\n";
			else if(wcschr(divide,L'"')||wcschr(divide,L'\'')){
				throw InvalidParamExc(2);
			}
			v = checkNull(new ArgVW);
			len = static_cast<ulong>(wcslen(txt));
//			printf("2");
			for(ulong i=0;i<=len;++i){
				c = *(txt + i);
				if(isArg){
					if(isQuote&&(isSQuoteIn||isDQuoteIn)){
						if((isSQuoteIn&&(c==L'\''))||(isDQuoteIn&&(c==L'"'))){
							isSQuoteIn = isDQuoteIn = isArg = false;
							v->lastIn(s);
							s.clear(false);
						}
						else s.lastInChar(c);
					}
					else if(wcschr(divide,c)){
						isArg = false;
						v->lastIn(s);
						s.clear(false);
					}
					else s.lastInChar(c);
				}
				else if(wcschr(divide,c)) continue;
				else if(isQuote&&(c==L'\'')) isSQuoteIn = isArg = true;
				else if(isQuote&&(c==L'"'))  isDQuoteIn = isArg = true;
				else{
					isArg = true;
					s.lastInChar(c);
				}
			}
//			printf("3");
			if(isArg) v->lastIn(s);
			return v;
		}

		inline void setArgTypeA(ARGTYPE type,ArgVA* v){
			char dir[MAX_PATH];
			switch(type){
				case NONE:
					v->firstOut();
				break;
				case CONSOLE:
					GetCurrentDirectoryA(MAX_PATH,dir);
					v->atFirst().firstInStr(PathAddBackslashA(dir));
				break;
				case EXENAME:
					strcpy(dir,v->atFirst());
					PathRenameExtensionA(dir,".exe");
					v->atFirst() = dir;
				break;
				case EXEPATH:
					strcpy(dir,v->atFirst());
					PathRenameExtensionA(dir,".exe");
					v->atFirst() = dir;
					GetCurrentDirectoryA(MAX_PATH,dir);
					PathAppendA(dir,v->atFirst());
					v->atFirst() = dir;
				break;
				case DIR:
					GetCurrentDirectoryA(MAX_PATH,dir);
					v->atFirst() = PathAddBackslashA(dir);
				break;
				case EXEDIR:
					GetCurrentDirectoryA(MAX_PATH,dir);
					PathAppendA(dir,v->atFirst());
					*PathFindFileNameA(dir) = NULL;
					v->atFirst() = dir;
				break;
			}
		}
		inline void setArgTypeW(ARGTYPE type,ArgVW* v){
			wchar_t dir[MAX_PATH];
			switch(type){
				case NONE:
					v->firstOut();
				break;
				case CONSOLE:
					GetCurrentDirectoryW(MAX_PATH,dir);
					v->atFirst().firstInStr(PathAddBackslashW(dir));
				break;
				case EXENAME:
					wcscpy(dir,v->atFirst());
					PathRenameExtensionW(dir,L".exe");
					v->atFirst() = dir;
				break;
				case EXEPATH:
					wcscpy(dir,v->atFirst());
					PathRenameExtensionW(dir,L".exe");
					v->atFirst() = dir;
					GetCurrentDirectoryW(MAX_PATH,dir);
					PathAppendW(dir,v->atFirst());
					v->atFirst() = dir;
				break;
				case DIR:
					GetCurrentDirectoryW(MAX_PATH,dir);
					v->atFirst() = PathAddBackslashW(dir);
				break;
				case EXEDIR:
					GetCurrentDirectoryW(MAX_PATH,dir);
					PathAppendW(dir,v->atFirst());
					*PathFindFileNameW(dir) = NULL;
					v->atFirst() = dir;
				break;
			}
		}

		ArgVA* createArgumentFromCommandLineA(ARGTYPE type)throw(OutOfMemExc){
			ArgVA* v = createArgumentA(GetCommandLineA());
			setArgTypeA(type,v);
			return v;
		}
		ArgVW* createArgumentFromCommandLineW(ARGTYPE type)throw(OutOfMemExc){
//			printf("a");
			ArgVW* v = createArgumentW(GetCommandLineW());
//			printf("b");
			setArgTypeW(type,v);
//			printf("c");
			return v;
		}

		void commandLineToArg(int* argc,str** argv,ARGTYPE type)throw(InvalidParamExc,OutOfMemExc){
			int count,i;
			str* list;
			if(!argc||!argv) throw InvalidParamExc(!argc?1:2);
			ArgVA* v = createArgumentA(GetCommandLineA());
			setArgTypeA(type,v);
			count = v->count();
			list = new str[v->count()];
			if(!list){
				delete v;
				throw OutOfMemExc(count*sizeof(str));
			}
			memset(list,0,v->count()*sizeof(str));
			for(i=v->count()-1;0<=i;--i){
				list[i] = _strdup(v->at(i-1));
				if(!list[i]) goto fail;
			}
			*argc = count;
			*argv = list;
			goto end;
		fail:
			for(++i;i<count;++i) free(list[i]);
			delete[] list;
		end:
			delete v;
		}
		void commandLineToArg(int* argc,wstr** argv,ARGTYPE type)throw(InvalidParamExc,OutOfMemExc){
			int count,i;
			wstr* list;
			if(!argc||!argv) throw InvalidParamExc(!argc?1:2);
			ArgVW* v = createArgumentW(GetCommandLineW());
			setArgTypeW(type,v);
			count = v->count();
			list = new wstr[v->count()];
			if(!list){
				delete v;
				throw OutOfMemExc(count*sizeof(wstr));
			}
			memset(list,0,v->count()*sizeof(wstr));
			for(i=v->count()-1;0<=i;--i){
				list[i] = _wcsdup(v->at(i-1));
				if(!list[i]) goto fail;
			}
			*argc = count;
			*argv = list;
			goto end;
		fail:
			for(++i;i<count;++i) free(list[i]);
			delete[] list;
		end:
			delete v;
		}

	}

}
