// 
// smart_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _smart_ptr_INCLUDED_
#define _smart_ptr_INCLUDED_

#include "Exceptions.h"

namespace scpl{

	/*
		̃t@Cɂ smart_ptr ƁA smart_ary NX`Ă܂B
		̃NX́AQƃJEgAQƂĂSẴ|C^
		NX delete ȂA|C^͊J܂B

		̃NXgpꍇAR[hƂ킩܂Af[^ɃANZX
		Zqgpꍇ̓`FbNs܂ixׁ̌̈jB
		`FbNĂقꍇ̓o֐gpĂB

		ӓ_ƂẮAQƂĂ|C^VNXɊ܂܂Ă͂܂B
		)
			smart_ptr<int> a(ptr),d,f;
			smart_ptr<int> b(ptr);     // NG
			smart_ptr<int> c(a.get()); // NG
			d = ptr;                   // NG
			smart_ptr<int> e(a);       // OK
			f = a;                     // OK

		Ȃ2-4sڂNGȂ̂ƌƁA1sڂƓ
		i|C^ւ̎QƃJEg̐jsĂ܂Aꂼ̎QƃJEg
		LłȀꍇAptrɑ΂4̉sĂ܂܂B
		̎d5-6sڂłB
		2-4sڂ̂悤ȏȂ΂ȂȂꍇ́Amanaged_ptrNX
		gpĂB

		W̉łdeleteydelete[]g܂A
		L̃}N֐gp΁Ǎ^̉sƂł܂B
		zۗLAǗꍇsmart_aryNXgpĂB
	*/

/*
	[U[`̉s}N֐(smart_ptrNX̂)B
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ_PtrłB
*/
#define smart_delete(type) template<> void scpl::smart_ptr<type>::manager::delptr()

	TMP class smart_ptr{
	public:
		typedef T*           ptr;
		typedef T&           ind;
		typedef const T*     cptr;
		typedef const T&     cind;
		typedef smart_ptr<T> self;
	private:
		void dec_del(){
			if(_pm&&(_pm->dec() == 0))
				delete _pm;
		}

		class manager{
			ulong _Count;
			T* _Ptr;

		public:
			manager(T* ptr):_Count(1),_Ptr(ptr){}
			~manager(){if(_Ptr) delptr();}

			T* get(){return _Ptr;}
			const T* get()const{return _Ptr;}
			void delptr(){delete _Ptr;}
			ulong count()const{return _Count;}
			ulong inc(){return _Count?(++_Count):_Count;}
			ulong dec(){return _Count?(--_Count):_Count;}

		};

	public:

		/* Rs[RXgN^B */
		smart_ptr(const self& p){
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* NULL ۗL܂B */
		smart_ptr():_pm(NULL){}
		/* |C^ۗL܂B */
		smart_ptr(ptr p)throw(OutOfMemExc):_pm(NULL){_pm = checkNull(new manager(p));}

		~smart_ptr(){dec_del();}

		/* |C^Ԃ܂B */
		operator ptr()const{return _pm->get();}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _pm==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == (_pm?_pm->get():NULL);}
		bool operator==(const self& p)const{return _pm == p._pm;}
		bool operator!=(cptr p)const{return p != (_pm?_pm->get():NULL);}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/* w肵|C^NX܂B */
		self& operator=(const self& p){set(p);return *this;}
		void set(const self& p){
			dec_del();
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* ̂QƂ܂B */
		ind operator*()const{return *_pm->get();}
		/* oQƂ܂B */
		ptr operator->()const{return _pm->get();}

		/* ̂Ԃ܂B */
		ind getIndirect()const throw(InvalidCallExc){
			if(_pm) return *_pm->get();
			throw InvalidCallExc();
		}
		/* |C^Ԃ܂B */
		ptr get()const{return _pm?_pm->get():NULL;}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_pm;}

		/* QƃJEgԂ܂B */
		ulong count()const{return _pm?_pm->count():0;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){dec_del();_pm = NULL;}

	protected:
		manager* _pm;

	};

	template<class T,size_t Count> class smart_ary{
	public:
		typedef T*                 ptr;
		typedef T&                 ind;
		typedef const T*           cptr;
		typedef const T&           cind;
		typedef smart_ary<T,Count> self;
	private:
		void dec_del(){if(_pm&&(_pm->dec() == 0)) delete _pm;}

		class manager{
			ulong _Count;
			T* _Ptr;

		public:
			manager(T* ptr):_Count(1),_Ptr(ptr){}
			~manager(){if(_Ptr) delptr();}

			T* get(){return _Ptr;}
			const T* get()const{return _Ptr;}
			T& at(ulong i){return _Ptr[i];}
			const T& at(ulong i)const{return _Ptr[i];}
			void delptr(){delete[] _Ptr;}
			ulong count()const{return _Count;}
			ulong inc(){return _Count?(++_Count):_Count;}
			ulong dec(){return _Count?(--_Count):_Count;}

		};

	public:

		/* Rs[RXgN^B */
		smart_ary(self& p){
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* NULL ۗL܂B */
		smart_ary():_pm(NULL){}
		/* |C^ۗL܂B */
		smart_ary(T(&p)[Count])throw(OutOfMemExc):_pm(NULL){_pm = checkNull(new manager(p));}

		~smart_ary(){dec_del();}

		/* |C^Ԃ܂B */
		operator ptr()const{return _pm;}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _pm==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == (_pm?_pm->get():NULL);}
		bool operator==(const self& p)const{return _pm == p._pm;}
		bool operator!=(cptr p)const{return p != (_pm?_pm->get():NULL);}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/* w肵|C^NX܂B */
		self& operator=(self& p){set(p);return *this;}
		void set(self& p){
			dec_del();
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/* ̂QƂ܂B */
		ind operator*()const{return *_pm->get();}
		/* oQƂ܂B */
		ptr operator->()const{return _pm->get();}
		/* w肵ʒũf[^Ԃ܂B */
		ind operator[](ulong i)const{return _pm->get()[i];}

		/* ̂Ԃ܂B */
		ind getIndirect()const throw(InvalidCallExc){
			if(_pm) return *_pm->get();
			throw InvalidCallExc();
		}
		/* |C^Ԃ܂B */
		ptr get()const{return _pm?_pm->get():NULL;}
		/* w肵ʒũf[^Ԃ܂B */
		ind at(ulong i)const throw(InvalidParamExc,InvalidCallExc){
			if(_pm){
				if(i < Count) return _pm->at(i);
				throw InvalidParamExc(1);
			}
			throw InvalidCallExc();
		}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_pm;}

		/* QƃJEgԂ܂B */
		ulong count()const{return _pm?_pm->count():0;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){dec_del();_pm = NULL;}

	protected:
		manager* _pm;

	};

} // namespace scpl
#endif